/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.AHtmlRef;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

public class HtmlLink
extends JPanel {
    private String mLinkLabel = "";
    private AHtmlRef mRef = null;
    private static Cursor sWaitCursor = new Cursor(12);
    private static Cursor sDefaultCursor = new Cursor(0);
    private int mTextWidth = 0;

    public HtmlLink(String string) {
        this(string, null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            this.mTextWidth = this.getFontMetrics(this.getFont()).stringWidth(this.mLinkLabel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HtmlLink(String string, AHtmlRef aHtmlRef) {
        this.setLayout(null);
        this.setRef(aHtmlRef);
        this.mLinkLabel = string;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (mouseEvent.getX() < HtmlLink.this.mTextWidth) {
                    HtmlLink.this.setCursor(sWaitCursor);
                } else {
                    HtmlLink.this.setCursor(sDefaultCursor);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (HtmlLink.this.mRef != null) {
                    HtmlLink.this.mRef.launchRef(mouseEvent);
                }
            }
        });
    }

    public String getLabel() {
        return this.mLinkLabel;
    }

    public void setLabel(String string) {
        this.mLinkLabel = string;
        this.repaint();
    }

    public void setRef(AHtmlRef aHtmlRef) {
        if (aHtmlRef != null) {
            this.mRef = aHtmlRef;
            this.add(this.mRef);
            this.mRef.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return new Dimension(fontMetrics.stringWidth(this.mLinkLabel), fontMetrics.getHeight() + 2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Font font = this.getFont();
        graphics.setColor(Color.blue);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.drawString(this.mLinkLabel, 0, fontMetrics.getAscent());
        int n = fontMetrics.getHeight();
        graphics.drawLine(0, n, fontMetrics.stringWidth(this.mLinkLabel), n);
    }
}

