/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Iterator;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.AdductFormula;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugAdductFormula
extends AdductFormula
implements IAdductFormula {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAdductFormula.class);

    public DebugAdductFormula() {
    }

    public DebugAdductFormula(IMolecularFormula formula) {
        super(formula);
    }

    public boolean contains(IIsotope isotope) {
        this.logger.debug((Object)"Contains Isotope?: ", new Object[]{isotope});
        return super.contains(isotope);
    }

    public Integer getCharge() {
        Integer charge = super.getCharge();
        this.logger.debug((Object)"Getting charge: ", new Object[]{charge});
        return charge;
    }

    public int getIsotopeCount(IIsotope isotope) {
        this.logger.debug((Object)"Getting isotope count for: ", new Object[]{isotope});
        return super.getIsotopeCount(isotope);
    }

    public int getIsotopeCount() {
        this.logger.debug((Object)"Getting isotope count: ", new Object[]{super.getIsotopeCount()});
        return super.getIsotopeCount();
    }

    public Iterable<IIsotope> isotopes() {
        this.logger.debug((Object)"Getting isotope iterator..");
        return super.isotopes();
    }

    public void setCharge(Integer charge) {
        this.logger.debug((Object)"Setting the charge to: ", new Object[]{charge});
        super.setCharge(charge);
    }

    public void add(IMolecularFormulaSet formulaSet) {
        this.logger.debug((Object)"Adding a formula set: ", new Object[]{formulaSet});
        super.add(formulaSet);
    }

    public void addMolecularFormula(IMolecularFormula formula) {
        this.logger.debug((Object)"Adding formula: ", new Object[]{formula});
        super.addMolecularFormula(formula);
    }

    public boolean contains(IMolecularFormula formula) {
        this.logger.debug((Object)"Contains formula?: ", new Object[]{formula});
        return super.contains(formula);
    }

    public IMolecularFormula getMolecularFormula(int position) {
        this.logger.debug((Object)"Getting formula at: ", new Object[]{position});
        return super.getMolecularFormula(position);
    }

    public Iterator<IMolecularFormula> iterator() {
        this.logger.debug((Object)"Getting molecular formula iterator...");
        return super.iterator();
    }

    public Iterable<IMolecularFormula> molecularFormulas() {
        this.logger.debug((Object)"Getting molecular formula iterable...");
        return super.molecularFormulas();
    }

    public void removeAllMolecularFormulas() {
        this.logger.debug((Object)"Removing all formulas...");
        super.removeAllMolecularFormulas();
    }

    public void removeMolecularFormula(IMolecularFormula formula) {
        this.logger.debug((Object)"Removing this formula: ", new Object[]{formula});
        super.removeMolecularFormula(formula);
    }

    public void removeMolecularFormula(int position) {
        this.logger.debug((Object)"Removing the formula at position: ", new Object[]{position});
        super.removeMolecularFormula(position);
    }

    public int size() {
        this.logger.debug((Object)("Getting the size of this adduct: " + super.size()));
        return super.size();
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

