/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultBondMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultMCSPlusAtomMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultMatcher;
import org.openscience.cdk.smsd.algorithm.mcgregor.McgregorHelper;
import org.openscience.cdk.smsd.helper.BinaryTree;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class McGregorChecks {
    protected static boolean isFurtherMappingPossible(IAtomContainer source, IAtomContainer target, int neighborBondNumA, int neighborBondNumB, List<Integer> iBondNeighborAtomsA, List<Integer> iBondNeighborAtomsB, List<String> cBondNeighborsA, List<String> cBondNeighborsB, boolean shouldMatchBonds) {
        for (int row = 0; row < neighborBondNumA; ++row) {
            String g1A = cBondNeighborsA.get(row * 4 + 0);
            String g2a = cBondNeighborsA.get(row * 4 + 1);
            for (int column = 0; column < neighborBondNumB; ++column) {
                String g2B;
                String g1B = cBondNeighborsB.get(column * 4 + 0);
                if (!McGregorChecks.isAtomMatch(g1A, g2a, g1B, g2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                try {
                    int indexI = iBondNeighborAtomsA.get(row * 3 + 0);
                    int indexIPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                    int indexJ = iBondNeighborAtomsB.get(column * 3 + 0);
                    int indexJPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                    IAtom r1A = source.getAtom(indexI);
                    IAtom r2A = source.getAtom(indexIPlus1);
                    IBond reactantBond = source.getBond(r1A, r2A);
                    IAtom p1B = target.getAtom(indexJ);
                    IAtom p2B = target.getAtom(indexJPlus1);
                    IBond productBond = target.getBond(p1B, p2B);
                    if (!McGregorChecks.isMatchFeasible(source, reactantBond, target, productBond, shouldMatchBonds)) continue;
                    return true;
                }
                catch (Exception e) {
                    LoggingToolFactory.createLoggingTool(McGregorChecks.class).warn((Object)"Unexpected Error:", new Object[]{e});
                }
            }
        }
        return false;
    }

    protected static boolean isMatchFeasible(IAtomContainer ac1, IBond bondA1, IAtomContainer ac2, IBond bondA2, boolean shouldMatchBonds) {
        if (ac1 instanceof IQueryAtomContainer) {
            if (((IQueryBond)bondA1).matches(bondA2)) {
                IQueryAtom atom1 = (IQueryAtom)bondA1.getBegin();
                IQueryAtom atom2 = (IQueryAtom)bondA1.getEnd();
                return atom1.matches(bondA2.getBegin()) && atom2.matches(bondA2.getEnd()) || atom1.matches(bondA2.getEnd()) && atom2.matches(bondA2.getBegin());
            }
            return false;
        }
        DefaultBondMatcher bondMatcher = new DefaultBondMatcher(ac1, bondA1, shouldMatchBonds);
        DefaultMCSPlusAtomMatcher atomMatcher1 = new DefaultMCSPlusAtomMatcher(ac1, bondA1.getBegin(), shouldMatchBonds);
        DefaultMCSPlusAtomMatcher atomMatcher2 = new DefaultMCSPlusAtomMatcher(ac1, bondA1.getEnd(), shouldMatchBonds);
        return DefaultMatcher.isBondMatch(bondMatcher, ac2, bondA2, shouldMatchBonds) && DefaultMatcher.isAtomMatch(atomMatcher1, atomMatcher2, ac2, bondA2, shouldMatchBonds);
    }

    protected static int searchCorrespondingAtom(int mappedAtomsSize, int atomFromOtherMolecule, int molecule, List<Integer> mappedAtomsOrg) {
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>(mappedAtomsOrg);
        int correspondingAtom = 0;
        for (int a = 0; a < mappedAtomsSize; ++a) {
            if (molecule == 1 && (Integer)mappedAtoms.get(a * 2 + 0) == atomFromOtherMolecule) {
                correspondingAtom = (Integer)mappedAtoms.get(a * 2 + 1);
            }
            if (molecule != 2 || (Integer)mappedAtoms.get(a * 2 + 1) != atomFromOtherMolecule) continue;
            correspondingAtom = (Integer)mappedAtoms.get(a * 2 + 0);
        }
        return correspondingAtom;
    }

    protected static boolean isAtomMatch(String g1A, String g2A, String g1B, String g2B) {
        return g1A.compareToIgnoreCase(g1B) == 0 && g2A.compareToIgnoreCase(g2B) == 0 || g1A.compareToIgnoreCase(g2B) == 0 && g2A.compareToIgnoreCase(g1B) == 0;
    }

    protected static int removeTreeStructure(BinaryTree curStruc) {
        BinaryTree equalStruc = curStruc.getEqual();
        BinaryTree notEqualStruc = curStruc.getNotEqual();
        curStruc = null;
        if (equalStruc != null) {
            McGregorChecks.removeTreeStructure(equalStruc);
        }
        if (notEqualStruc != null) {
            McGregorChecks.removeTreeStructure(notEqualStruc);
        }
        return 0;
    }

    protected static List<Integer> removeRecurringMappings(List<Integer> atomMapping) {
        boolean exist = true;
        ArrayList<Integer> tempMap = new ArrayList<Integer>();
        int tempCounter = 0;
        int atomMappingSize = atomMapping.size();
        for (int x = 0; x < atomMappingSize; x += 2) {
            int atom = atomMapping.get(x);
            for (int y = x + 2; y < atomMappingSize; y += 2) {
                if (atom != atomMapping.get(y)) continue;
                exist = false;
            }
            if (exist) {
                tempMap.add(atomMapping.get(x + 0));
                tempMap.add(atomMapping.get(x + 1));
                tempCounter += 2;
            }
            exist = true;
        }
        return tempMap;
    }

    protected static void removeRedundantArcs(int row, int column, List<Integer> marcs, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        int g1Atom = iBondNeighborAtomsA.get(row * 3 + 0);
        int g2Atom = iBondNeighborAtomsA.get(row * 3 + 1);
        int g3Atom = iBondNeighborAtomsB.get(column * 3 + 0);
        int g4Atom = iBondNeighborAtomsB.get(column * 3 + 1);
        for (int x = 0; x < neighborBondNumA; ++x) {
            int rowAtom1 = iBondNeighborAtomsA.get(x * 3 + 0);
            int rowAtom2 = iBondNeighborAtomsA.get(x * 3 + 1);
            for (int y = 0; y < neighborBondNumB; ++y) {
                int columnAtom4;
                int columnAtom3 = iBondNeighborAtomsB.get(y * 3 + 0);
                if (!McGregorChecks.cases(g1Atom, g2Atom, g3Atom, g4Atom, rowAtom1, rowAtom2, columnAtom3, columnAtom4 = iBondNeighborAtomsB.get(y * 3 + 1).intValue())) continue;
                marcs.set(x * neighborBondNumB + y, 0);
            }
        }
        for (int v = 0; v < neighborBondNumA; ++v) {
            marcs.set(v * neighborBondNumB + column, 0);
        }
        for (int w = 0; w < neighborBondNumB; ++w) {
            marcs.set(row * neighborBondNumB + w, 0);
        }
        marcs.set(row * neighborBondNumB + column, 1);
    }

    protected static List<String> generateCSetCopy(int bondNumber, List<String> cSet) {
        ArrayList<String> cTabCopy = new ArrayList<String>();
        for (int a = 0; a < bondNumber; ++a) {
            cTabCopy.add(cSet.get(a * 4 + 0));
            cTabCopy.add(cSet.get(a * 4 + 1));
            cTabCopy.add("X");
            cTabCopy.add("X");
        }
        return cTabCopy;
    }

    protected static List<String> generateCTabCopy(IAtomContainer atomContainer) throws IOException {
        ArrayList<String> cTabCopy = new ArrayList<String>();
        for (int a = 0; a < atomContainer.getBondCount(); ++a) {
            String atomI = atomContainer.getBond(a).getBegin().getSymbol();
            String atomJ = atomContainer.getBond(a).getEnd().getSymbol();
            cTabCopy.add(atomI);
            cTabCopy.add(atomJ);
            cTabCopy.add("X");
            cTabCopy.add("X");
        }
        return cTabCopy;
    }

    protected static boolean case1(int g1Atom, int g3Atom, int g4Atom, int rowAtom1, int rowAtom2, int columnAtom3, int columnAtom4) {
        return (g1Atom == rowAtom1 || g1Atom == rowAtom2) && columnAtom3 != g3Atom && columnAtom4 != g3Atom && columnAtom3 != g4Atom && columnAtom4 != g4Atom;
    }

    protected static boolean case2(int g2Atom, int g3Atom, int g4Atom, int rowAtom1, int rowAtom2, int columnAtom3, int columnAtom4) {
        return (g2Atom == rowAtom1 || g2Atom == rowAtom2) && columnAtom3 != g3Atom && columnAtom4 != g3Atom && columnAtom3 != g4Atom && columnAtom4 != g4Atom;
    }

    protected static boolean case3(int g1Atom, int g3Atom, int g2Atom, int rowAtom1, int rowAtom2, int columnAtom3, int columnAtom4) {
        return (g3Atom == columnAtom3 || g3Atom == columnAtom4) && rowAtom1 != g1Atom && rowAtom2 != g1Atom && rowAtom1 != g2Atom && rowAtom2 != g2Atom;
    }

    protected static boolean case4(int g1Atom, int g2Atom, int g4Atom, int rowAtom1, int rowAtom2, int columnAtom3, int columnAtom4) {
        return (g4Atom == columnAtom3 || g4Atom == columnAtom4) && rowAtom1 != g1Atom && rowAtom2 != g1Atom && rowAtom1 != g2Atom && rowAtom2 != g2Atom;
    }

    protected static boolean cases(int g1Atom, int g2Atom, int g3Atom, int g4Atom, int rowAtom1, int rowAtom2, int columnAtom3, int columnAtom4) {
        return McGregorChecks.case1(g1Atom, g3Atom, g4Atom, rowAtom1, rowAtom2, columnAtom3, columnAtom4) || McGregorChecks.case2(g2Atom, g3Atom, g4Atom, rowAtom1, rowAtom2, columnAtom3, columnAtom4) || McGregorChecks.case3(g1Atom, g3Atom, g2Atom, rowAtom1, rowAtom2, columnAtom3, columnAtom4) || McGregorChecks.case4(g1Atom, g2Atom, g4Atom, rowAtom1, rowAtom2, columnAtom3, columnAtom4);
    }

    protected static List<Integer> setArcs(IAtomContainer source, IAtomContainer target, int neighborBondNumA, int neighborBondNumB, List<Integer> iBondNeighborAtomsA, List<Integer> iBondNeighborAtomsB, List<String> cBondNeighborsA, List<String> cBondNeighborsB, List<Integer> modifiedARCS, boolean shouldMatchBonds) {
        for (int row = 0; row < neighborBondNumA; ++row) {
            for (int column = 0; column < neighborBondNumB; ++column) {
                IAtom p2B;
                String g2B;
                String g1B;
                String g2A;
                String g1A = cBondNeighborsA.get(row * 4 + 0);
                if (!McGregorChecks.isAtomMatch(g1A, g2A = cBondNeighborsA.get(row * 4 + 1), g1B = cBondNeighborsB.get(column * 4 + 0), g2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                int indexI = iBondNeighborAtomsA.get(row * 3 + 0);
                int indexIPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                IAtom r1A = source.getAtom(indexI);
                IAtom r2A = source.getAtom(indexIPlus1);
                IBond reactantBond = source.getBond(r1A, r2A);
                int indexJ = iBondNeighborAtomsB.get(column * 3 + 0);
                int indexJPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                IAtom p1B = target.getAtom(indexJ);
                IBond productBond = target.getBond(p1B, p2B = target.getAtom(indexJPlus1));
                if (!McGregorChecks.isMatchFeasible(source, reactantBond, target, productBond, shouldMatchBonds)) continue;
                modifiedARCS.set(row * neighborBondNumB + column, 1);
            }
        }
        return modifiedARCS;
    }

    protected static int countArcsLeft(List<Integer> tempmarcs, int neighborBondNumA, int neighborBondNumB) {
        int arcsleft = 0;
        for (int a = 0; a < neighborBondNumA; ++a) {
            for (int b = 0; b < neighborBondNumB; ++b) {
                if (tempmarcs.get(a * neighborBondNumB + b) != 1) continue;
                ++arcsleft;
            }
        }
        return arcsleft;
    }

    protected static int changeCharBonds(int correspondingAtom, String newSymbol, int neighborBondNum, IAtomContainer atomContainer, List<String> cBondNeighbors) {
        for (int atomIndex = 0; atomIndex < neighborBondNum; ++atomIndex) {
            IBond bond = atomContainer.getBond(atomIndex);
            if (atomContainer.indexOf(bond.getBegin()) == correspondingAtom && cBondNeighbors.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                cBondNeighbors.set(atomIndex * 4 + 2, cBondNeighbors.get(atomIndex * 4 + 0));
                cBondNeighbors.set(atomIndex * 4 + 0, newSymbol);
            }
            if (atomContainer.indexOf(bond.getEnd()) != correspondingAtom || cBondNeighbors.get(atomIndex * 4 + 3).compareToIgnoreCase("X") != 0) continue;
            cBondNeighbors.set(atomIndex * 4 + 3, cBondNeighbors.get(atomIndex * 4 + 1));
            cBondNeighbors.set(atomIndex * 4 + 1, newSymbol);
        }
        return 0;
    }

    protected static int changeCharBonds(int correspondingAtom, String newSymbol, int neighborBondNum, List<Integer> iBondNeighbors, List<String> cBondNeighbors) {
        for (int atomIndex = 0; atomIndex < neighborBondNum; ++atomIndex) {
            if (iBondNeighbors.get(atomIndex * 3 + 0) == correspondingAtom && cBondNeighbors.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                cBondNeighbors.set(atomIndex * 4 + 2, cBondNeighbors.get(atomIndex * 4 + 0));
                cBondNeighbors.set(atomIndex * 4 + 0, newSymbol);
            }
            if (iBondNeighbors.get(atomIndex * 3 + 1) != correspondingAtom || cBondNeighbors.get(atomIndex * 4 + 3).compareToIgnoreCase("X") != 0) continue;
            cBondNeighbors.set(atomIndex * 4 + 3, cBondNeighbors.get(atomIndex * 4 + 1));
            cBondNeighbors.set(atomIndex * 4 + 1, newSymbol);
        }
        return 0;
    }

    static boolean isFurtherMappingPossible(IAtomContainer source, IAtomContainer target, McgregorHelper mcGregorHelper, boolean shouldMatchBonds) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        List<String> cBondNeighborsA = mcGregorHelper.getcBondNeighborsA();
        List<String> cBondNeighborsB = mcGregorHelper.getcBondNeighborsB();
        for (int row = 0; row < neighborBondNumA; ++row) {
            String g1A = cBondNeighborsA.get(row * 4 + 0);
            String g2A = cBondNeighborsA.get(row * 4 + 1);
            for (int column = 0; column < neighborBondNumB; ++column) {
                String g2B;
                String g1B = cBondNeighborsB.get(column * 4 + 0);
                if (!McGregorChecks.isAtomMatch(g1A, g2A, g1B, g2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                try {
                    int indexI = iBondNeighborAtomsA.get(row * 3 + 0);
                    int indexIPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                    int indexJ = iBondNeighborAtomsB.get(column * 3 + 0);
                    int indexJPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                    IAtom r1A = source.getAtom(indexI);
                    IAtom r2A = source.getAtom(indexIPlus1);
                    IBond reactantBond = source.getBond(r1A, r2A);
                    IAtom p1B = target.getAtom(indexJ);
                    IAtom p2B = target.getAtom(indexJPlus1);
                    IBond productBond = target.getBond(p1B, p2B);
                    if (!McGregorChecks.isMatchFeasible(source, reactantBond, target, productBond, shouldMatchBonds)) continue;
                    return true;
                }
                catch (Exception e) {
                    LoggingToolFactory.createLoggingTool(McGregorChecks.class).warn((Object)"Unexpected Error:", new Object[]{e});
                }
            }
        }
        return false;
    }

    static List<Integer> markUnMappedAtoms(boolean flag, IAtomContainer container, Map<Integer, Integer> presentMapping) {
        ArrayList<Integer> unmappedMolAtoms = new ArrayList<Integer>();
        int unmappedNum = 0;
        boolean atomIsUnmapped = true;
        for (int a = 0; a < container.getAtomCount(); ++a) {
            if (flag && presentMapping.containsKey(a)) {
                atomIsUnmapped = false;
            } else if (!flag && presentMapping.containsValue(a)) {
                atomIsUnmapped = false;
            }
            if (atomIsUnmapped) {
                unmappedMolAtoms.add(unmappedNum++, a);
            }
            atomIsUnmapped = true;
        }
        return unmappedMolAtoms;
    }

    static List<Integer> markUnMappedAtoms(boolean flag, IAtomContainer container, List<Integer> mappedAtoms, int cliqueSize) {
        ArrayList<Integer> unmappedMolAtoms = new ArrayList<Integer>();
        int unmappedNum = 0;
        boolean atomIsUnmapped = true;
        for (int a = 0; a < container.getAtomCount(); ++a) {
            for (int b = 0; b < cliqueSize; b += 2) {
                if (flag && mappedAtoms.get(b) == a) {
                    atomIsUnmapped = false;
                    continue;
                }
                if (flag || mappedAtoms.get(b + 1) != a) continue;
                atomIsUnmapped = false;
            }
            if (atomIsUnmapped) {
                unmappedMolAtoms.add(unmappedNum++, a);
            }
            atomIsUnmapped = true;
        }
        return unmappedMolAtoms;
    }
}

