/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaDate {
    private static final String ALPHA_ZONE_PATTERN = "EEE MMM  d HH:mm:ss ZZZ yyyy";
    private static final DateTimeFormatter ALPHA_ZONE_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM  d HH:mm:ss ZZZ yyyy");
    private static final String ALPHA_PATTERN1 = "EEE MMM  d HH:mm:ss yyyy";
    private static final String ALPHA_PATTERN2 = "EEE MMM dd HH:mm:ss yyyy";
    private static final DateTimeFormatter ALPHA_FORMATTER1 = DateTimeFormat.forPattern((String)"EEE MMM  d HH:mm:ss yyyy");
    private static final DateTimeFormatter ALPHA_FORMATTER2 = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss yyyy");
    private static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZZ";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
    private static final String ZULU_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z";
    private static final DateTimeFormatter ZULU_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z");

    public static String formatDate(DateTime datetime) {
        if (DateTimeZone.UTC.equals((Object)datetime.getZone())) {
            return ZULU_FORMATTER.print((ReadableInstant)datetime);
        }
        return DATETIME_FORMATTER.print((ReadableInstant)datetime);
    }

    public static String formatIsoDate(DateTime datetime) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)datetime);
    }

    public static DateTime parseDate(String s) {
        if (s.endsWith("Z")) {
            MutableDateTime dateTime = ZULU_FORMATTER.parseMutableDateTime(s);
            dateTime.setZone(DateTimeZone.UTC);
            return dateTime.toDateTime();
        }
        if (Character.isLetter(s.charAt(0))) {
            DateTime dateTime = JodaDate.parseQuietly(ALPHA_FORMATTER2, s);
            if (dateTime == null) {
                dateTime = JodaDate.parseQuietly(ALPHA_FORMATTER1, s);
            }
            return dateTime;
        }
        return DATETIME_FORMATTER.parseDateTime(s);
    }

    public static DateTime parseQuietly(DateTimeFormatter formatter, String s) {
        DateTime dateTime = null;
        if (formatter != null) {
            try {
                dateTime = formatter.parseDateTime(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateTime;
    }

    public static DateTime parseDate(String date, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format);
        if (!format.endsWith("Z")) {
            dateTimeFormatter = dateTimeFormatter.withZone(DateTimeZone.forID((String)"UTC"));
        }
        DateTime dateTime = dateTimeFormatter.parseDateTime(date);
        return dateTime.withZone(DateTimeZone.forID((String)"UTC"));
    }

    public static DateTime parseJavaDate(Date javaDate) {
        long seconds = javaDate.getTime();
        return new DateTime(seconds);
    }

    public static Date parseJodaDate(DateTime jodaDate) {
        int year = jodaDate.getYear();
        int month = jodaDate.getMonthOfYear();
        int day = jodaDate.getDayOfMonth();
        int hour = jodaDate.getHourOfDay();
        int min = jodaDate.getMinuteOfDay();
        int sec = jodaDate.getSecondOfMinute();
        Date date = new Date(year - 1900, month, day, hour, min, sec);
        return date;
    }
}

