/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import jebl.evolution.graphs.Node;
import jebl.evolution.trees.FilteredRootedTree;
import jebl.evolution.trees.RootedTree;

public class TransformedRootedTree
extends FilteredRootedTree {
    private final Transform transform;

    public TransformedRootedTree(RootedTree source, Transform transform) {
        super(source);
        this.transform = transform;
    }

    public boolean hasHeights() {
        return true;
    }

    public double getHeight(Node node) {
        switch (this.transform) {
            case EQUAL_LENGTHS: {
                int treeLength = this.getMaxPathLength(this.getRootNode());
                int rootPathLength = this.getPathLengthToRoot(node);
                return treeLength - rootPathLength;
            }
            case CLADOGRAM: {
                return this.getMaxPathLength(node);
            }
            case PROPORTIONAL: {
                return this.getCladeSize(node) - 1;
            }
        }
        throw new IllegalArgumentException("Unknown enum value");
    }

    public boolean hasLengths() {
        return true;
    }

    public double getLength(Node node) {
        switch (this.transform) {
            case EQUAL_LENGTHS: {
                return 1.0;
            }
            case CLADOGRAM: 
            case PROPORTIONAL: {
                Node parent = this.getParent(node);
                if (parent == null) {
                    return 0.0;
                }
                return this.getHeight(parent) - this.getHeight(node);
            }
        }
        throw new IllegalArgumentException("Unknown enum value");
    }

    private int getCladeSize(Node node) {
        if (this.isExternal(node)) {
            return 1;
        }
        int size = 0;
        for (Node child : this.getChildren(node)) {
            size += this.getCladeSize(child);
        }
        return size;
    }

    private int getMaxPathLength(Node node) {
        if (this.isExternal(node)) {
            return 0;
        }
        int maxPathLength = 0;
        for (Node child : this.getChildren(node)) {
            int pathLength = this.getMaxPathLength(child);
            if (pathLength <= maxPathLength) continue;
            maxPathLength = pathLength;
        }
        return maxPathLength + 1;
    }

    private int getPathLengthToRoot(Node node) {
        int pathLength = 0;
        Node parent = this.getParent(node);
        while (parent != null) {
            ++pathLength;
            parent = this.getParent(parent);
        }
        return pathLength;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transform {
        EQUAL_LENGTHS("equal"),
        CLADOGRAM("cladogram"),
        PROPORTIONAL("proportional");

        private String name;

        private Transform(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

