/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.io.Importer;
import dr.evomodel.arg.ARGModel;
import dr.util.Identifiable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ARGTrace
implements Identifiable {
    private ArrayList<ARGModel> args = new ArrayList();
    private int minState;
    private int stepSize;
    private String id;

    public int getTreeCount(int n) {
        int n2 = (n - this.minState) / this.stepSize;
        if (n2 < 0) {
            n2 = 0;
        }
        return this.args.size() - n2;
    }

    public ARGModel getARG(int n, int n2) {
        int n3 = (n2 - this.minState) / this.stepSize;
        if (n3 < 0) {
            n3 = 0;
        }
        return this.args.get(n + n3);
    }

    public void add(ARGModel aRGModel) {
        this.args.add(aRGModel);
    }

    public void setMinimumState(int n) {
        this.minState = n;
    }

    public int getMinimumState() {
        return this.minState;
    }

    public void setStepSize(int n) {
        this.stepSize = n;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public int getMaximumState() {
        return (this.args.size() - 1) * this.stepSize + this.minState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public static ARGTrace loadARGTrace(Reader reader) throws IOException, Importer.ImportException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ARGTrace aRGTrace = new ARGTrace();
        ARGModel aRGModel = null;
        int n = -1;
        int n2 = 0;
        ARGModel aRGModel2 = new ARGModel(null, null, 0, 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        aRGModel = aRGModel2;
        while ((string = bufferedReader.readLine()) != null) {
            string.trim();
            if (!string.toUpperCase().startsWith("ARG")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            arrayList.add(stringTokenizer.nextToken());
            ARGModel aRGModel3 = aRGModel2.fromGraphStringCompressed(stringTokenizer.nextToken().trim());
            aRGTrace.add(aRGModel3);
        }
        if (arrayList.size() < 2) {
            throw new Importer.ImportException("Less than two ARGs in the trace file");
        }
        n = ARGTrace.getStateNumber((String)arrayList.get(0));
        n2 = ARGTrace.getStateNumber((String)arrayList.get(1)) - n;
        aRGTrace.setMinimumState(n);
        aRGTrace.setStepSize(n2);
        return aRGTrace;
    }

    private static final int getStateNumber(String string) throws Importer.ImportException {
        try {
            return Integer.parseInt(string.substring(string.indexOf(95) + 1).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Importer.ImportException("Bad state number in tree label '" + string + "', the state must be preceded by an underscore(_).");
        }
    }
}

