/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.json.stream.JsonGenerator;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;

public class Text
extends Annotation {
    String text;
    Font basefont;
    float basefontSize = 14.0f;
    Font lastFont;
    float lastFontSize = 0.0f;

    public Text(int x, int y, String text, Color color, Font basefont, AnnotationPanel nl) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.color = color;
        this.basefont = basefont;
        this.basefontSize = basefont.getSize();
        this.lastFont = basefont;
        this.nl = nl;
    }

    @Override
    public void writeObject(JsonGenerator gen) {
    }

    @Override
    public Dimension paintObject(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.color);
        if (this.lastFontSize != (float)((double)this.basefontSize * this.nl.getZoom())) {
            this.lastFontSize = (float)((double)this.basefontSize * this.nl.getZoom());
            this.lastFont = this.basefont.deriveFont(this.lastFontSize);
        }
        g.setFont(this.lastFont);
        g.drawString(this.text, (int)((double)this.x * this.nl.getZoom()), (int)((double)this.y * this.nl.getZoom()));
        FontMetrics fm = g.getFontMetrics();
        return new Dimension(fm.stringWidth(this.text), fm.getHeight());
    }

    @Override
    public String getLaTeX() {
        return null;
    }

    @Override
    public Annotation readJSON(String json) {
        return null;
    }

    @Override
    public boolean inYou(int x, int y) {
        return false;
    }

    public void setText(String text) {
        this.text = text;
    }
}

