/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.PascalDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.MathUtils;

public class PascalDistributionImpl
extends AbstractIntegerDistribution
implements PascalDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public PascalDistributionImpl(int r, double p) {
        this.setNumberOfSuccessesInternal(r);
        this.setProbabilityOfSuccessInternal(p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Deprecated
    public void setNumberOfSuccesses(int successes) {
        this.setNumberOfSuccessesInternal(successes);
    }

    private void setNumberOfSuccessesInternal(int successes) {
        if (successes < 0) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes must be non-negative ({0})", successes);
        }
        this.numberOfSuccesses = successes;
    }

    @Deprecated
    public void setProbabilityOfSuccess(double p) {
        this.setProbabilityOfSuccessInternal(p);
    }

    private void setProbabilityOfSuccessInternal(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", p, 0.0, 1.0);
        }
        this.probabilityOfSuccess = p;
    }

    protected int getDomainLowerBound(double p) {
        return -1;
    }

    protected int getDomainUpperBound(double p) {
        return 0x7FFFFFFE;
    }

    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, x + 1);
        return ret;
    }

    public double probability(int x) {
        double ret = x < 0 ? 0.0 : MathUtils.binomialCoefficientDouble(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * Math.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * Math.pow(1.0 - this.probabilityOfSuccess, x);
        return ret;
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        int ret = p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : super.inverseCumulativeProbability(p));
        return ret;
    }
}

