## ----setup, include = FALSE, echo = FALSE, warning = FALSE--------------------
knitr::opts_chunk$set(echo = TRUE)
knitr::opts_chunk$set(dev = "png", dev.args = list(type = "cairo-png"))

## ----message=FALSE, warning=FALSE, echo=FALSE---------------------------------
library(HaDeX2)
library(magrittr)

## ----include=TRUE-------------------------------------------------------------
dat <- read_hdx(system.file(package = "HaDeX2", "HaDeX/data/alpha.csv"))

## -----------------------------------------------------------------------------
uptake_dat <- create_state_uptake_dataset(dat)

## -----------------------------------------------------------------------------
plot_butterfly(uptake_dat)

## -----------------------------------------------------------------------------
plot_chiclet(uptake_dat)

