/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.DMatrixSparse;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;

public class DMatrixSparseTriplet
implements DMatrixSparse {
    public Element[] nz_data = new Element[0];
    public int nz_length;
    public int numRows;
    public int numCols;

    public DMatrixSparseTriplet() {
    }

    public DMatrixSparseTriplet(int numRows, int numCols, int initLength) {
        this.growData(initLength);
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public DMatrixSparseTriplet(DMatrixSparseTriplet orig) {
        this.set(orig);
    }

    public void reset() {
        this.nz_length = 0;
        this.numRows = 0;
        this.numCols = 0;
    }

    public void reshape(int numRows, int numCols) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.nz_length = 0;
    }

    @Override
    public void reshape(int numRows, int numCols, int arrayLength) {
        this.reshape(numRows, numCols);
        this.growData(arrayLength);
    }

    public void addItem(int row, int col, double value) {
        if (this.nz_length == this.nz_data.length) {
            this.growData(this.nz_length * 2 + 10);
        }
        this.nz_data[this.nz_length++].set(row, col, value);
    }

    @Override
    public void set(int row, int col, double value) {
        if (row < 0 || row >= this.numRows || col < 0 || col >= this.numCols) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        this.unsafe_set(row, col, value);
    }

    @Override
    public void unsafe_set(int row, int col, double value) {
        int index = this.nz_index(row, col);
        if (index < 0) {
            this.addItem(row, col, value);
        } else {
            this.nz_data[index].value = value;
        }
    }

    @Override
    public int getNumElements() {
        return this.nz_length;
    }

    @Override
    public double get(int row, int col) {
        if (row < 0 || row >= this.numRows || col < 0 || col >= this.numCols) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        return this.unsafe_get(row, col);
    }

    @Override
    public double unsafe_get(int row, int col) {
        int index = this.nz_index(row, col);
        if (index < 0) {
            return 0.0;
        }
        return this.nz_data[index].value;
    }

    public int nz_index(int row, int col) {
        for (int i = 0; i < this.nz_length; ++i) {
            Element e = this.nz_data[i];
            if (e.row != row || e.col != col) continue;
            return i;
        }
        return -1;
    }

    public void growData(int max_nz_length) {
        if (this.nz_data.length < max_nz_length) {
            Element[] tmp = new Element[max_nz_length];
            System.arraycopy(this.nz_data, 0, tmp, 0, this.nz_data.length);
            for (int i = this.nz_data.length; i < max_nz_length; ++i) {
                tmp[i] = new Element();
            }
            this.nz_data = tmp;
        }
    }

    public int getLength() {
        return this.nz_length;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public <T extends Matrix> T copy() {
        return (T)new DMatrixSparseTriplet(this);
    }

    @Override
    public <T extends Matrix> T createLike() {
        return (T)new DMatrixSparseTriplet(this.numRows, this.numCols, this.nz_length);
    }

    @Override
    public void set(Matrix original) {
        DMatrixSparseTriplet orig = (DMatrixSparseTriplet)original;
        this.reshape(orig.numRows, orig.numCols);
        this.growData(orig.nz_length);
        this.nz_length = orig.nz_length;
        for (int i = 0; i < this.nz_length; ++i) {
            this.nz_data[i].set(orig.nz_data[i]);
        }
    }

    @Override
    public void shrinkArrays() {
        if (this.nz_length < this.nz_data.length) {
            Element[] tmp_data = new Element[this.nz_length];
            System.arraycopy(this.nz_data, 0, tmp_data, 0, this.nz_length);
            this.nz_data = tmp_data;
        }
    }

    @Override
    public void remove(int row, int col) {
        int where = this.nz_index(row, col);
        if (where >= 0) {
            Element e = this.nz_data[where];
            --this.nz_length;
            for (int i = where; i < this.nz_length; ++i) {
                this.nz_data[i] = this.nz_data[i + 1];
            }
            this.nz_data[this.nz_length] = e;
        }
    }

    @Override
    public boolean isAssigned(int row, int col) {
        return this.nz_index(row, col) >= 0;
    }

    @Override
    public void zero() {
        this.nz_length = 0;
    }

    @Override
    public void print() {
        System.out.println(this.getClass().getSimpleName() + "\n , numRows = " + this.numRows + " , numCols = " + this.numCols + " , nz_length = " + this.nz_length);
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                int index = this.nz_index(row, col);
                if (index >= 0) {
                    System.out.printf("%6.3f", this.nz_data[index].value);
                } else {
                    System.out.print("   *  ");
                }
                if (col == this.numCols - 1) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    @Override
    public void printNonZero() {
        System.out.println(this.getClass().getSimpleName() + "\n , numRows = " + this.numRows + " , numCols = " + this.numCols + " , nz_length = " + this.nz_length);
        for (int i = 0; i < this.nz_length; ++i) {
            Element e = this.nz_data[i];
            System.out.printf("%d %d %f\n", e.row, e.col, e.value);
        }
    }

    @Override
    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }

    public static class Element {
        public int row;
        public int col;
        public double value;

        public void set(int row, int col, double value) {
            this.row = row;
            this.col = col;
            this.value = value;
        }

        public void set(Element e) {
            this.row = e.row;
            this.col = e.col;
            this.value = e.value;
        }
    }
}

