## ----message=F,warning=F------------------------------------------------------
library(CNSigs)

## ----eval=F-------------------------------------------------------------------
# readSegs("./SampleSegs.txt",colMap = c("Sample_ID","Chrom","Start","End","Total_CN"))

## ----fig.width=7, fig.height=7------------------------------------------------
smooth = smoothSegs(segDataExp)

#Visualize the smoothed segments
toPlot = list(segDataExp[[1]],smooth[[1]])
names(toPlot) = c("Original","Smoothed")
plotSegs(toPlot, sep = T)

## -----------------------------------------------------------------------------
feats = extractCNFeats(smooth)

## ----eval=F-------------------------------------------------------------------
# comps = fitModels(feats)

## ----fig=T,fig.height=4,echo=F------------------------------------------------
  hist(featsExp$copynumber$value,breaks=100, main = "Histogram of orignal copynumber data",
       xlab = "Copynumber values")

## ----fig=T,fig.height=4,echo=F------------------------------------------------
  test = CNSigs:::reducePeaks(featsExp$copynumber$value)
  hist(test,breaks=100, main = "Histogram of copynumber after reduction",
       xlab = "Copynumber values")

## ----fig.height=3-------------------------------------------------------------
scm = generateSCM(feats, cancerComps)
plotScm(scm)

## ----eval = F-----------------------------------------------------------------
# scm = addPloidyData(scm, ploidyData)

## ----eval = F-----------------------------------------------------------------
# sigs = createSigs(scm, 5)

## ----eval = F-----------------------------------------------------------------
# sigs = findExposures(scm, fixedSigs)

## ----eval=F-------------------------------------------------------------------
# results = runPipeline(segDataExp)

## ----eval=F-------------------------------------------------------------------
# results = runPipeline(segData, components = cancerComps)

## ----eval=F-------------------------------------------------------------------
# #referenceExp = readRDS("resultsPath/Pipeline results.rds")
# newResults = runPipeline(segData, components = referenceExp$CN_components,
#                          fixedSigs = referenceExp$sigs)

## ----eval=F-------------------------------------------------------------------
# newResults = runPipeline(segData, components = cancerComps,
#                          fixedSigs = collapsedSigs, ploidyData = segPloidy)

## ----fig.width=7, fig.height=4------------------------------------------------
plotComp(cancerComps,"bp10MB") #Only plots the bp10MB component

## ----eval = F-----------------------------------------------------------------
# plotComps(cancerComps) #Plots all of the components

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"segsize")

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"bp10MB")

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"osCN")

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"changepoint")

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"copynumber")

## ----fig=T,fig.height=5,echo=F------------------------------------------------
  plotComp(cancerComps,"bpchrarm")

## -----------------------------------------------------------------------------
matchSigs(referenceExp$sigs,referenceExp$sigs)

## ----fig.width=7, fig.height=6------------------------------------------------
sigSim(referenceExp,referenceExp)

## -----------------------------------------------------------------------------
plotSigExposureMat(referenceExp$sigExposure)

## ----fig.height=3-------------------------------------------------------------
plotSigExposure(referenceExp$sigExposure)

## ----fig.height=4-------------------------------------------------------------
sigExposure = referenceExp$sigExposure

# Generate random data to represent track data
sampleTrackData = sample(c(1,2,3,4),ncol(sigExposure),T)
sampleTrackData2 = sample(c(1,2,3,4),ncol(sigExposure),T)

# Plot with a single track
plotSigExposure(sigExposure,trackData = sampleTrackData)

# Plot multiple tracks.
plotSigExposure(sigExposure, trackData = list(sampleTrackData,sampleTrackData2))

## ----fig.height=4-------------------------------------------------------------
# Plot multiple tracks sorted by the main plot and then the first track
plotSigExposure(sigExposure, trackData = list(sampleTrackData,sampleTrackData2),
                sort=T,sortOrder = "mt1")

# Plot multiple tracks sorted by the second track and then the first track
plotSigExposure(sigExposure, trackData = list(sampleTrackData,sampleTrackData2),
                sort=T,sortOrder = "t2t1m")

## ----eval=F-------------------------------------------------------------------
# smooth = smoothSegs(segDataExp)
# feats = extractCNFeats(smooth)
# comps = fitModels(feats)
# determineNumSigs(feats,comps)

## ----eval=F-------------------------------------------------------------------
# detSigNumPipeline(segDataExp,smooth=T)

## -----------------------------------------------------------------------------
defaultFeats

desiredFeats = defaultFeats[-3]
desiredFeats

## ----eval=F-------------------------------------------------------------------
# results = runPipeline(segDataExp,featsToUse = desiredFeats)

