% Generated by roxygen2: do not edit by hand
\name{chol}
\alias{chol}
\title{Cholesky Decomposition}
\arguments{
  \item{x}{a symmetric, positive-definite matrix}
  \item{pivot}{logical. If TRUE, performs pivoting to increase numerical stability.
}
}

\details{
Basic usage of \{.help [\{.fun chol\}](base::chol)\}
\code{
A <- matrix(c(4, 12, -16, 12, 37, -43, -16, -43, 98), ncol = 3)
chol(A)  # upper triangular factor
}

Usage with pivoting for numerical stability
\code{
chol(A, pivot = TRUE)  # upper triangular factor with pivoting
}

Checking that A = LL'
\code{
L <- chol(A)
all.equal(A, L \%*\% t(L), tol = 1e-6)
}}

