/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import java.util.stream.IntStream;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.restopt.choco.ConnectivityFinderSpatialGraph;

public class PropEffectiveMeshSize
extends Propagator<Variable> {
    protected UndirectedGraphVar g;
    protected IntVar mesh;
    protected int landscapeArea;
    protected int precision;
    public ConnectivityFinderSpatialGraph connectivityFinderGUB;
    public ConnectivityFinderSpatialGraph connectivityFinderGLB;
    private final boolean maximize;
    private int multiplier;

    public PropEffectiveMeshSize(UndirectedGraphVar g, IntVar mesh, int landscapeArea, int precison, boolean maximize) {
        this(g, mesh, IntStream.range(0, g.getNbMaxNodes()).map(i -> 1).toArray(), landscapeArea, precison, maximize);
    }

    public PropEffectiveMeshSize(UndirectedGraphVar g, IntVar mesh, int[] cellsArea, int landscapeArea, int precison, boolean maximize) {
        super(new Variable[]{g, mesh}, (Priority)PropagatorPriority.VERY_SLOW, false);
        this.g = g;
        this.mesh = mesh;
        this.landscapeArea = landscapeArea;
        this.precision = precison;
        this.multiplier = (int)Math.pow(10.0, this.precision);
        this.connectivityFinderGUB = new ConnectivityFinderSpatialGraph((UndirectedGraph)g.getUB(), cellsArea);
        this.connectivityFinderGLB = new ConnectivityFinderSpatialGraph((UndirectedGraph)g.getLB(), (UndirectedGraph)g.getUB(), cellsArea);
        this.maximize = maximize;
    }

    public PropEffectiveMeshSize(UndirectedGraphVar g, IntVar mesh, int landscapeArea, int precison) {
        this(g, mesh, landscapeArea, precison, false);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (!this.maximize || this.g.getMandatoryNodes().size() == this.g.getPotentialNodes().size()) {
            int mesh_LB_round = this.getLB();
            this.mesh.updateLowerBound(mesh_LB_round, (ICause)this);
        }
        int mesh_UB_round = this.getUB();
        this.mesh.updateUpperBound(mesh_UB_round, (ICause)this);
        if (this.mesh.getLB() == mesh_UB_round) {
            ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (this.g.getMandatoryNodes().contains(i)) continue;
                this.g.enforceNode(i, this);
            }
            this.mesh.instantiateTo(mesh_UB_round, (ICause)this);
        } else {
            boolean filtered = false;
            if (this.g.getMandatoryNodes().size() != this.g.getPotentialNodes().size()) {
                for (int i = 0; i < this.connectivityFinderGUB.getNBCC(); ++i) {
                    int s = this.connectivityFinderGUB.getAttributeCC()[i];
                    double d = 1.0 / (double)this.landscapeArea * (double)((s - 1) * (s - 1) - s * s);
                    int delta = (int)Math.round(d * (double)this.multiplier);
                    if (mesh_UB_round + delta >= this.mesh.getLB()) continue;
                    filtered = true;
                    for (int j : this.connectivityFinderGUB.getCC(i)) {
                        if (this.g.getMandatoryNodes().contains(j)) continue;
                        this.g.enforceNode(j, this);
                    }
                }
                if (filtered && (!this.maximize || this.g.getMandatoryNodes().size() == this.g.getPotentialNodes().size())) {
                    int mesh_LB_round = this.getLB();
                    this.mesh.updateLowerBound(mesh_LB_round, (ICause)this);
                }
            }
        }
    }

    private int getLB() {
        double mesh_LB = 0.0;
        this.connectivityFinderGLB.findAllCC();
        for (int i = 0; i < this.connectivityFinderGLB.getNBCC(); ++i) {
            int s = this.connectivityFinderGLB.getAttributeCC()[i];
            mesh_LB += 1.0 * (double)s * (double)s;
        }
        int mesh_LB_round = (int)Math.round((mesh_LB /= 1.0 * (double)this.landscapeArea) * (double)this.multiplier);
        return mesh_LB_round;
    }

    private int getUB() {
        double mesh_UB = 0.0;
        this.connectivityFinderGUB.findAllCC();
        for (int i = 0; i < this.connectivityFinderGUB.getNBCC(); ++i) {
            int s = this.connectivityFinderGUB.getAttributeCC()[i];
            mesh_UB += 1.0 * (double)s * (double)s;
        }
        int mesh_UB_round = (int)Math.round((mesh_UB /= 1.0 * (double)this.landscapeArea) * (double)this.multiplier);
        return mesh_UB_round;
    }

    @Override
    public ESat isEntailed() {
        int mesh_LB_round = this.getLB();
        int mesh_UB_round = this.getUB();
        if (mesh_LB_round > this.mesh.getUB() || mesh_UB_round < this.mesh.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

