/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.hybrid;

import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public abstract class ASupport {
    IntVar var;
    final BitSet ac = new BitSet();
    int offset;
    int cnt;

    ASupport() {
    }

    final void setVar(IntVar var) {
        this.var = var;
        this.reset();
    }

    void reset() {
        this.ac.clear();
        this.offset = this.var.getLB();
        this.cnt = this.var.getDomainSize();
    }

    final IntVar getVar() {
        return this.var;
    }

    abstract void support(int var1);

    abstract void supportAll();

    public static final class StrHVar
    extends ASupport {
        final int index;
        final IStateInt last_size;

        StrHVar(IEnvironment env, IntVar var_, int index_) {
            this.var = var_;
            this.last_size = env.makeInt(0);
            this.index = index_;
        }

        boolean removeUnsupportedValue(ICause cause) throws ContradictionException {
            boolean filter = false;
            if (this.var.hasEnumeratedDomain()) {
                int val = this.var.getLB();
                while (this.cnt > 0 && val <= this.var.getUB()) {
                    if (!this.ac.get(val - this.offset)) {
                        filter |= this.var.removeValue(val, cause);
                        --this.cnt;
                    }
                    val = this.var.nextValue(val);
                }
            } else {
                int val = this.var.getLB();
                while (this.cnt > 0 && val <= this.var.getUB()) {
                    if (!this.ac.get(val - this.offset)) {
                        if (!this.var.removeValue(val, cause)) break;
                        filter = true;
                        --this.cnt;
                    }
                    val = this.var.nextValue(val);
                }
                val = this.var.getUB();
                while (this.cnt > 0 && val >= this.var.getLB()) {
                    if (!this.ac.get(val - this.offset)) {
                        if (!this.var.removeValue(val, cause)) break;
                        filter = true;
                        --this.cnt;
                    }
                    val = this.var.previousValue(val);
                }
            }
            return filter;
        }

        @Override
        void support(int value) {
            if (!this.ac.get(value -= this.offset)) {
                this.ac.set(value);
                --this.cnt;
            }
        }

        @Override
        void supportAll() {
            this.cnt = 0;
        }

        public String toString() {
            return this.var.getName();
        }
    }

    static class AndSupport
    extends ASupport {
        final BitSet and = new BitSet();

        AndSupport() {
        }

        @Override
        void reset() {
            super.reset();
            this.and.set(0, this.var.getDomainSize());
        }

        @Override
        void support(int value) {
            if ((value -= this.offset) > -1) {
                this.ac.set(value);
            }
        }

        @Override
        void supportAll() {
            this.ac.or(this.and);
        }

        void filter() {
            this.and.and(this.ac);
            this.ac.clear();
        }

        public void transferTo(ASupport v) {
            int i = this.and.nextSetBit(0);
            while (i > -1) {
                v.support(i + this.offset);
                i = this.and.nextSetBit(i + 1);
            }
            this.reset();
        }
    }
}

