/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import java.util.Arrays;
import org.chocosolver.memory.trailing.StoredInt;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;

public class StoredIntTrail
implements IStoredIntTrail {
    private final double loadfactor;
    private StoredInt[] variableStack;
    private int[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public StoredIntTrail(int nUpdates, int nWorlds, double loadfactor) {
        this.variableStack = new StoredInt[nUpdates];
        this.valueStack = new int[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
        this.loadfactor = loadfactor;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
        if (worldIndex == this.worldStartLevels.length - 1) {
            this.worldStartLevels = Arrays.copyOf(this.worldStartLevels, (int)((double)this.worldStartLevels.length * this.loadfactor));
        }
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredInt v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[worldIndex];
        int prevWorld = worldIndex - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredInt var = this.variableStack[level];
            int val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.overrideTimeStamp(prevWorld);
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public void savePreviousState(StoredInt v, int oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.variableStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
        StoredInt[] tmp1 = new StoredInt[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        int[] tmp2 = new int[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }
}

