/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.trail.StoredDoubleTrail;

public final class StoredDouble
extends AbstractStoredObject
implements IStateDouble {
    private double currentValue;
    protected final StoredDoubleTrail myTrail;

    public StoredDouble(EnvironmentTrailing env, double d) {
        super(env);
        this.currentValue = d;
        this.worldStamp = env.getWorldIndex();
        this.myTrail = env.getDoubleTrail();
    }

    @Override
    public double get() {
        return this.currentValue;
    }

    @Override
    public void set(double y) {
        if (y != this.currentValue) {
            if (this.worldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, this.currentValue, this.worldStamp);
                this.worldStamp = this.environment.getWorldIndex();
            }
            this.currentValue = y;
        }
    }

    @Override
    public double add(double delta) {
        this.set(this.currentValue + delta);
        return this.currentValue;
    }

    public void _set(double y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public String toString() {
        return String.valueOf(this.currentValue);
    }
}

