/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new Object[n * n2];
    }

    protected DenseObjectMatrix2D(int n, int n2, Object[] objectArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = objectArray;
        this.isNoView = !bl;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        Object object = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseObjectMatrix2D.this.elements[n + n4 * DenseObjectMatrix2D.this.rowStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseObjectMatrix2D.this.columns; ++j) {
                                object = objectObjectFunction.apply(object, objectFunction.apply(DenseObjectMatrix2D.this.elements[n + i * DenseObjectMatrix2D.this.rowStride + j * DenseObjectMatrix2D.this.columnStride]));
                            }
                            n2 = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    object = objectObjectFunction.apply(object, objectFunction.apply(this.elements[n + i * this.rowStride + j * this.columnStride]));
                }
                n6 = 0;
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, final ObjectProcedure objectProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        Object object = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = DenseObjectMatrix2D.this.elements[n + n4 * DenseObjectMatrix2D.this.rowStride];
                        Object object2 = 0;
                        if (objectProcedure.apply(object)) {
                            object2 = objectFunction.apply(object);
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseObjectMatrix2D.this.columns; ++j) {
                                object = DenseObjectMatrix2D.this.elements[n + i * DenseObjectMatrix2D.this.rowStride + j * DenseObjectMatrix2D.this.columnStride];
                                if (!objectProcedure.apply(object)) continue;
                                object2 = objectObjectFunction.apply(object2, objectFunction.apply(object));
                            }
                            n2 = 0;
                        }
                        return object2;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            Object object2 = this.elements[n];
            if (objectProcedure.apply(object2)) {
                object = objectFunction.apply(this.elements[n]);
            }
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    object2 = this.elements[n + i * this.rowStride + j * this.columnStride];
                    if (!objectProcedure.apply(object2)) continue;
                    object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                }
                n6 = 0;
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        Object object = null;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n2);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseObjectMatrix2D.this.elements[n + nArray[n5] * DenseObjectMatrix2D.this.rowStride + nArray2[n5] * DenseObjectMatrix2D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            Object object2 = DenseObjectMatrix2D.this.elements[n + nArray[i] * DenseObjectMatrix2D.this.rowStride + nArray2[i] * DenseObjectMatrix2D.this.columnStride];
                            object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n + nArray[0] * this.rowStride + nArray2[0] * this.columnStride]);
            for (int i = 1; i < n2; ++i) {
                Object object2 = this.elements[n + nArray[i] * this.rowStride + nArray2[i] * this.columnStride];
                object = objectObjectFunction.apply(object, objectFunction.apply(object2));
            }
        }
        return object;
    }

    public Object aggregate(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.aggregate(objectMatrix2D, objectObjectFunction, objectObjectFunction2);
        }
        this.checkShape(objectMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)objectMatrix2D.index(0, 0);
        final int n3 = objectMatrix2D.rowStride();
        final int n4 = objectMatrix2D.columnStride();
        final Object[] objectArray = (Object[])objectMatrix2D.elements();
        Object object = null;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectObjectFunction2.apply(DenseObjectMatrix2D.this.elements[n + n7 * DenseObjectMatrix2D.this.rowStride], objectArray[n2 + n7 * n3]);
                        int n5 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n5; j < DenseObjectMatrix2D.this.columns; ++j) {
                                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(DenseObjectMatrix2D.this.elements[n + i * DenseObjectMatrix2D.this.rowStride + j * DenseObjectMatrix2D.this.columnStride], objectArray[n2 + i * n3 + j * n4]));
                            }
                            n5 = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            int n9 = 1;
            object = objectObjectFunction2.apply(this.elements[n], objectArray[n2]);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.elements[n + i * this.rowStride + j * this.columnStride], objectArray[n2 + i * n3 + j * n4]));
                }
                n9 = 0;
            }
        }
        return object;
    }

    public ObjectMatrix2D assign(final Object object) {
        final Object[] objectArray = this.elements;
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseObjectMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                objectArray[n2] = object;
                                n2 += DenseObjectMatrix2D.this.columnStride;
                            }
                            n3 += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    objectArray[n7] = object;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[][] objectArray) {
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n2;
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.rows : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                Object[] objectArray2 = objectArray[i];
                                if (objectArray2.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                System.arraycopy(objectArray2, 0, DenseObjectMatrix2D.this.elements, n, DenseObjectMatrix2D.this.columns);
                                n += DenseObjectMatrix2D.this.columns;
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    Object[] objectArray2 = objectArray[i];
                    if (objectArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(objectArray2, 0, this.elements, n6, this.columns);
                    n6 += this.columns;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n9 = this.rows / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.rows : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n10 * DenseObjectMatrix2D.this.rowStride;
                            for (int i = n10; i < n11; ++i) {
                                Object[] objectArray2 = objectArray[i];
                                if (objectArray2.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                    DenseObjectMatrix2D.this.elements[n2] = objectArray2[j];
                                    n2 += DenseObjectMatrix2D.this.columnStride;
                                }
                                n += DenseObjectMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n12 = n7;
                for (int i = 0; i < this.rows; ++i) {
                    Object[] objectArray3 = objectArray[i];
                    if (objectArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                    }
                    int n13 = n12;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n13] = objectArray3[j];
                        n13 += this.columnStride;
                    }
                    n12 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        final Object[] objectArray = this.elements;
        if (objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseObjectMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                objectArray[n2] = objectFunction.apply(objectArray[n2]);
                                n2 += DenseObjectMatrix2D.this.columnStride;
                            }
                            n3 += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    objectArray[n7] = objectFunction.apply(objectArray[n7]);
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure objectProcedure, final ObjectFunction objectFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseObjectMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                Object object = DenseObjectMatrix2D.this.elements[n2];
                                if (objectProcedure.apply(object)) {
                                    DenseObjectMatrix2D.this.elements[n2] = objectFunction.apply(object);
                                }
                                n2 += DenseObjectMatrix2D.this.columnStride;
                            }
                            n3 += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    Object object = this.elements[n7];
                    if (objectProcedure.apply(object)) {
                        this.elements[n7] = objectFunction.apply(object);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure objectProcedure, final Object object) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseObjectMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                Object object2 = DenseObjectMatrix2D.this.elements[n2];
                                if (objectProcedure.apply(object2)) {
                                    DenseObjectMatrix2D.this.elements[n2] = object;
                                }
                                n2 += DenseObjectMatrix2D.this.columnStride;
                            }
                            n3 += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    Object object2 = this.elements[n7];
                    if (objectProcedure.apply(object2)) {
                        this.elements[n7] = object;
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        Object[] objectArray;
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D);
        }
        DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        if (denseObjectMatrix2D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseObjectMatrix2D.isNoView) {
            System.arraycopy(denseObjectMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseObjectMatrix2D denseObjectMatrix2D2 = (DenseObjectMatrix2D)objectMatrix2D;
        if (this.haveSharedCells(denseObjectMatrix2D2)) {
            objectArray = denseObjectMatrix2D2.copy();
            if (!(objectArray instanceof DenseObjectMatrix2D)) {
                super.assign(denseObjectMatrix2D2);
                return this;
            }
            denseObjectMatrix2D2 = (DenseObjectMatrix2D)objectArray;
        }
        objectArray = denseObjectMatrix2D2.elements;
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n2 = (int)denseObjectMatrix2D2.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseObjectMatrix2D2.columnStride;
        final int n5 = denseObjectMatrix2D2.rowStride;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + n7 * DenseObjectMatrix2D.this.rowStride;
                        int n22 = n2 + n7 * n5;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n;
                            int n42 = n22;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                DenseObjectMatrix2D.this.elements[n32] = objectArray[n42];
                                n32 += DenseObjectMatrix2D.this.columnStride;
                                n42 += n4;
                            }
                            n += DenseObjectMatrix2D.this.rowStride;
                            n22 += n5;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3;
            int n10 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = objectArray[n12];
                    n11 += this.columnStride;
                    n12 += n4;
                }
                n9 += this.rowStride;
                n10 += n5;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D, objectObjectFunction);
        }
        DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        this.checkShape(objectMatrix2D);
        final Object[] objectArray = denseObjectMatrix2D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseObjectMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseObjectMatrix2D.columnStride;
        final int n4 = denseObjectMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n2 + n7 * DenseObjectMatrix2D.this.rowStride;
                        int n22 = n + n7 * n4;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                DenseObjectMatrix2D.this.elements[n32] = objectObjectFunction.apply(DenseObjectMatrix2D.this.elements[n32], objectArray[n42]);
                                n32 += DenseObjectMatrix2D.this.columnStride;
                                n42 += n3;
                            }
                            n5 += DenseObjectMatrix2D.this.rowStride;
                            n22 += n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = objectObjectFunction.apply(this.elements[n11], objectArray[n12]);
                    n11 += this.columnStride;
                    n12 += n3;
                }
                n9 += this.rowStride;
                n10 += n4;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] objectArray) {
        if ((long)objectArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + objectArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.rows : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix2D.this.columns;
                            int n22 = n2 + n4 * DenseObjectMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                    DenseObjectMatrix2D.this.elements[n3] = objectArray[n++];
                                    n3 += DenseObjectMatrix2D.this.columnStride;
                                }
                                n22 += DenseObjectMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n8] = objectArray[n6++];
                        n8 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(objectMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final Object[] objectArray = (Object[])objectMatrix2D.elements();
        final int n2 = (int)objectMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = objectMatrix2D.columnStride();
        final int n5 = objectMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, n);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n = n3 + nArray[i] * DenseObjectMatrix2D.this.rowStride + nArray2[i] * DenseObjectMatrix2D.this.columnStride;
                            int n22 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                            DenseObjectMatrix2D.this.elements[n] = objectObjectFunction.apply(DenseObjectMatrix2D.this.elements[n], objectArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n10 = n3 + nArray[i] * this.rowStride + nArray2[i] * this.columnStride;
                int n11 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                this.elements[n10] = objectObjectFunction.apply(this.elements[n10], objectArray[n11]);
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D selectedDenseObjectMatrix2D = (SelectedDenseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedDenseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
            return this.elements == denseObjectMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new DenseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new DenseObjectMatrix1D(n, this.elements, n2, n3, true);
    }

    public void setQuick(int n, int n2, Object object) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = object;
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D((int)this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)denseObjectMatrix1D.index(0);
        final int n3 = denseObjectMatrix1D.stride();
        final Object[] objectArray = (Object[])denseObjectMatrix1D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                final int n8 = i * n5 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n8 * n3;
                        for (int i = n6; i < n7; ++i) {
                            n4 = n + i * DenseObjectMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseObjectMatrix2D.this.rows; ++j) {
                                objectArray[n22] = DenseObjectMatrix2D.this.elements[n4];
                                n4 += DenseObjectMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    objectArray[n10] = this.elements[n9];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseObjectMatrix1D;
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

