/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCGS
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D u;
    private FloatMatrix1D phat;
    private FloatMatrix1D qhat;
    private FloatMatrix1D vhat;
    private FloatMatrix1D uhat;
    private FloatMatrix1D sum;
    private FloatMatrix1D r;
    private FloatMatrix1D rtilde;

    public FloatCGS(FloatMatrix1D floatMatrix1D) {
        this.p = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.u = floatMatrix1D.copy();
        this.phat = floatMatrix1D.copy();
        this.qhat = floatMatrix1D.copy();
        this.vhat = floatMatrix1D.copy();
        this.uhat = floatMatrix1D.copy();
        this.sum = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
        this.rtilde = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            f = this.rtilde.zDotProduct(this.r);
            if (f == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.u.assign(this.r);
                this.p.assign(this.u);
            } else {
                f4 = f / f2;
                this.u.assign(this.r).assign(this.q, FloatFunctions.plusMultSecond(f4));
                this.sum.assign(this.q).assign(this.p, FloatFunctions.plusMultSecond(f4));
                this.p.assign(this.u).assign(this.sum, FloatFunctions.plusMultSecond(f4));
            }
            this.M.apply(this.p, this.phat);
            floatMatrix2D.zMult(this.phat, this.vhat);
            f3 = f / this.rtilde.zDotProduct(this.vhat);
            this.q.assign(this.vhat, FloatFunctions.multSecond(-f3)).assign(this.u, FloatFunctions.plus);
            this.M.apply(this.sum.assign(this.u).assign(this.q, FloatFunctions.plus), this.uhat);
            floatMatrix1D2.assign(this.uhat, FloatFunctions.plusMultSecond(f3));
            floatMatrix2D.zMult(this.uhat, this.qhat);
            this.r.assign(this.qhat, FloatFunctions.plusMultSecond(-f3));
            f2 = f;
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

