## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(biogrowth)
library(tidyverse)

## -----------------------------------------------------------------------------
data("example_od")
example_od %>%
  pivot_longer(-"time") %>%
  ggplot() +
  geom_line(aes(x = time, y = value, colour = name)) +
  theme(legend.position = "none")

## -----------------------------------------------------------------------------
c(0:4) %>%
    map(.,
        ~ predict_growth(seq(0, 100, length = 1000),
                         list(model = "Baranyi", 
                              logN0 = log10(100/6^.),
                              logNmax = 8,
                              mu = .2, lambda = 15))
        ) %>%
    imap_dfr(., ~ mutate(.x$simulation, dil = .y-1)) %>%
    ggplot() +
    geom_line(aes(x = time, y = logN, colour = factor(dil))) +
    geom_hline(yintercept = 6, linetype = 2) +
    theme(legend.position = "none")

## -----------------------------------------------------------------------------
data("example_od")
head(example_od)

## -----------------------------------------------------------------------------
my_TTDs <- get_TTDs(example_od, target_OD = 0.2)
head(my_TTDs)

## -----------------------------------------------------------------------------
names(example_od)[c(2, 5, 8)]

## -----------------------------------------------------------------------------
my_TTDs <- get_TTDs(example_od, target_OD = 0.2, codified = TRUE)
head(my_TTDs)

## -----------------------------------------------------------------------------
my_data <- filter(my_TTDs, condition == "S/6,5/35/R1")

## -----------------------------------------------------------------------------
my_fit <- fit_serial_dilution(my_data, start = c(a = 0, mu = .1))

## -----------------------------------------------------------------------------
my_fit

## -----------------------------------------------------------------------------
coef(my_fit)

## -----------------------------------------------------------------------------
summary(my_fit)

## -----------------------------------------------------------------------------
plot(my_fit)

## -----------------------------------------------------------------------------
fit_max5 <- fit_serial_dilution(my_data, start = c(a = 0, mu = .1), max_dil = 5)

## -----------------------------------------------------------------------------
plot(fit_max5)

## -----------------------------------------------------------------------------
coef(fit_max5)

## -----------------------------------------------------------------------------
my_fit2 <- fit_serial_dilution(my_data, 
                               start = c(lambda = 0, mu = .1),
                               mode = "lambda", 
                               logN_det = 7.5,
                               logN_dil0 = 4)

## -----------------------------------------------------------------------------
plot(my_fit2)

## -----------------------------------------------------------------------------
summary(my_fit2)

## -----------------------------------------------------------------------------
coef(my_fit)

