/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DTest;
import cern.colt.matrix.tfcomplex.impl.DenseColumnFComplexMatrix2D;

public class DenseColumnFComplexMatrix2DTest
extends FComplexMatrix2DTest {
    public DenseColumnFComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseColumnFComplexMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseColumnFComplexMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseColumnFComplexMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testAssignFloatArray() {
        float[] fArray = new float[2 * (int)this.A.size()];
        int n = 0;
        while ((long)n < 2L * this.A.size()) {
            fArray[n] = (float)Math.random();
            ++n;
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                float[] fArray2 = this.A.getQuick(j, i);
                DenseColumnFComplexMatrix2DTest.assertEquals((float)fArray[n], (float)fArray2[0], (float)this.TOL);
                DenseColumnFComplexMatrix2DTest.assertEquals((float)fArray[n + 1], (float)fArray2[1], (float)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignFloatArrayArray() {
        int n;
        int n2;
        float[][] fArray = new float[this.A.columns()][2 * this.A.rows()];
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            for (n = 0; n < 2 * this.A.rows(); ++n) {
                fArray[n2][n] = (float)Math.random();
            }
        }
        this.A.assign(fArray);
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            for (n = 0; n < this.A.rows(); ++n) {
                float[] fArray2 = this.A.getQuick(n, n2);
                DenseColumnFComplexMatrix2DTest.assertEquals((float)fArray[n2][2 * n], (float)fArray2[0], (float)this.TOL);
                DenseColumnFComplexMatrix2DTest.assertEquals((float)fArray[n2][2 * n + 1], (float)fArray2[1], (float)this.TOL);
            }
        }
    }

    public void testFft2() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        ((DenseColumnFComplexMatrix2D)this.A).fft2();
        ((DenseColumnFComplexMatrix2D)this.A).ifft2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(fComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testFftColumns() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        ((DenseColumnFComplexMatrix2D)this.A).fftColumns();
        ((DenseColumnFComplexMatrix2D)this.A).ifftColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(fComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testFftRows() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        ((DenseColumnFComplexMatrix2D)this.A).fftRows();
        ((DenseColumnFComplexMatrix2D)this.A).ifftRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(fComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }
}

