/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Property;
import dr.math.MathUtils;
import java.io.Serializable;

public class RobustSingularValueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;
    private static int maxIterationsDefault = 100000;
    private static final String ERROR_STRING = "SVD is not converged.";

    public RobustSingularValueDecomposition(DoubleMatrix2D doubleMatrix2D) throws ArithmeticException {
        this(doubleMatrix2D, maxIterationsDefault);
    }

    public RobustSingularValueDecomposition(DoubleMatrix2D doubleMatrix2D, int n) throws ArithmeticException {
        int n2;
        double d;
        int n3;
        int n4;
        Property.DEFAULT.checkRectangular(doubleMatrix2D);
        double[][] dArray = doubleMatrix2D.toArray();
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        int n5 = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][n5];
        this.V = new double[this.n][this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.m];
        boolean bl = true;
        boolean bl2 = true;
        int n6 = Math.min(this.m - 1, this.n);
        int n7 = Math.max(0, Math.min(this.n - 2, this.m));
        for (n4 = 0; n4 < Math.max(n6, n7); ++n4) {
            int n8;
            if (n4 < n6) {
                this.s[n4] = 0.0;
                for (n3 = n4; n3 < this.m; ++n3) {
                    this.s[n4] = MathUtils.hypot(this.s[n4], dArray[n3][n4]);
                }
                if (this.s[n4] != 0.0) {
                    if (dArray[n4][n4] < 0.0) {
                        this.s[n4] = -this.s[n4];
                    }
                    for (n3 = n4; n3 < this.m; ++n3) {
                        double[] dArray4 = dArray[n3];
                        int n9 = n4;
                        dArray4[n9] = dArray4[n9] / this.s[n4];
                    }
                    double[] dArray5 = dArray[n4];
                    int n10 = n4;
                    dArray5[n10] = dArray5[n10] + 1.0;
                }
                this.s[n4] = -this.s[n4];
            }
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                if (n4 < n6 & this.s[n4] != 0.0) {
                    double d2 = 0.0;
                    for (n8 = n4; n8 < this.m; ++n8) {
                        d2 += dArray[n8][n4] * dArray[n8][n3];
                    }
                    d2 = -d2 / dArray[n4][n4];
                    for (n8 = n4; n8 < this.m; ++n8) {
                        double[] dArray6 = dArray[n8];
                        int n11 = n3;
                        dArray6[n11] = dArray6[n11] + d2 * dArray[n8][n4];
                    }
                }
                dArray2[n3] = dArray[n4][n3];
            }
            if (bl & n4 < n6) {
                for (n3 = n4; n3 < this.m; ++n3) {
                    this.U[n3][n4] = dArray[n3][n4];
                }
            }
            if (n4 >= n7) continue;
            dArray2[n4] = 0.0;
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                dArray2[n4] = MathUtils.hypot(dArray2[n4], dArray2[n3]);
            }
            if (dArray2[n4] != 0.0) {
                if (dArray2[n4 + 1] < 0.0) {
                    dArray2[n4] = -dArray2[n4];
                }
                n3 = n4 + 1;
                while (n3 < this.n) {
                    int n12 = n3++;
                    dArray2[n12] = dArray2[n12] / dArray2[n4];
                }
                int n13 = n4 + 1;
                dArray2[n13] = dArray2[n13] + 1.0;
            }
            dArray2[n4] = -dArray2[n4];
            if (n4 + 1 < this.m & dArray2[n4] != 0.0) {
                for (n3 = n4 + 1; n3 < this.m; ++n3) {
                    dArray3[n3] = 0.0;
                }
                for (n3 = n4 + 1; n3 < this.n; ++n3) {
                    for (int i = n4 + 1; i < this.m; ++i) {
                        int n14 = i;
                        dArray3[n14] = dArray3[n14] + dArray2[n3] * dArray[i][n3];
                    }
                }
                for (n3 = n4 + 1; n3 < this.n; ++n3) {
                    double d3 = -dArray2[n3] / dArray2[n4 + 1];
                    for (n8 = n4 + 1; n8 < this.m; ++n8) {
                        double[] dArray7 = dArray[n8];
                        int n15 = n3;
                        dArray7[n15] = dArray7[n15] + d3 * dArray3[n8];
                    }
                }
            }
            if (!bl2) continue;
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                this.V[n3][n4] = dArray2[n3];
            }
        }
        n4 = Math.min(this.n, this.m + 1);
        if (n6 < this.n) {
            this.s[n6] = dArray[n6][n6];
        }
        if (this.m < n4) {
            this.s[n4 - 1] = 0.0;
        }
        if (n7 + 1 < n4) {
            dArray2[n7] = dArray[n7][n4 - 1];
        }
        dArray2[n4 - 1] = 0.0;
        if (bl) {
            for (n3 = n6; n3 < n5; ++n3) {
                for (int i = 0; i < this.m; ++i) {
                    this.U[i][n3] = 0.0;
                }
                this.U[n3][n3] = 1.0;
            }
            for (n3 = n6 - 1; n3 >= 0; --n3) {
                int n16;
                if (this.s[n3] != 0.0) {
                    for (n16 = n3 + 1; n16 < n5; ++n16) {
                        d = 0.0;
                        for (n2 = n3; n2 < this.m; ++n2) {
                            d += this.U[n2][n3] * this.U[n2][n16];
                        }
                        d = -d / this.U[n3][n3];
                        for (n2 = n3; n2 < this.m; ++n2) {
                            double[] dArray8 = this.U[n2];
                            int n17 = n16;
                            dArray8[n17] = dArray8[n17] + d * this.U[n2][n3];
                        }
                    }
                    for (n16 = n3; n16 < this.m; ++n16) {
                        this.U[n16][n3] = -this.U[n16][n3];
                    }
                    this.U[n3][n3] = 1.0 + this.U[n3][n3];
                    for (n16 = 0; n16 < n3 - 1; ++n16) {
                        this.U[n16][n3] = 0.0;
                    }
                    continue;
                }
                for (n16 = 0; n16 < this.m; ++n16) {
                    this.U[n16][n3] = 0.0;
                }
                this.U[n3][n3] = 1.0;
            }
        }
        if (bl2) {
            for (n3 = this.n - 1; n3 >= 0; --n3) {
                int n18;
                if (n3 < n7 & dArray2[n3] != 0.0) {
                    for (n18 = n3 + 1; n18 < n5; ++n18) {
                        d = 0.0;
                        for (n2 = n3 + 1; n2 < this.n; ++n2) {
                            d += this.V[n2][n3] * this.V[n2][n18];
                        }
                        d = -d / this.V[n3 + 1][n3];
                        for (n2 = n3 + 1; n2 < this.n; ++n2) {
                            double[] dArray9 = this.V[n2];
                            int n19 = n18;
                            dArray9[n19] = dArray9[n19] + d * this.V[n2][n3];
                        }
                    }
                }
                for (n18 = 0; n18 < this.n; ++n18) {
                    this.V[n18][n3] = 0.0;
                }
                this.V[n3][n3] = 1.0;
            }
        }
        n3 = n4 - 1;
        int n20 = 0;
        d = Math.pow(2.0, -52.0);
        block35: while (n4 > 0) {
            int n21;
            int n22;
            if (n20 > n) {
                throw new ArithmeticException(ERROR_STRING);
            }
            for (n2 = n4 - 2; n2 >= -1 && n2 != -1; --n2) {
                if (!(Math.abs(dArray2[n2]) <= d * (Math.abs(this.s[n2]) + Math.abs(this.s[n2 + 1])))) continue;
                dArray2[n2] = 0.0;
                break;
            }
            if (n2 == n4 - 2) {
                n22 = 4;
            } else {
                for (n21 = n4 - 1; n21 >= n2 && n21 != n2; --n21) {
                    double d4 = (n21 != n4 ? Math.abs(dArray2[n21]) : 0.0) + (n21 != n2 + 1 ? Math.abs(dArray2[n21 - 1]) : 0.0);
                    if (!(Math.abs(this.s[n21]) <= d * d4)) continue;
                    this.s[n21] = 0.0;
                    break;
                }
                if (n21 == n2) {
                    n22 = 3;
                } else if (n21 == n4 - 1) {
                    n22 = 1;
                } else {
                    n22 = 2;
                    n2 = n21;
                }
            }
            ++n2;
            switch (n22) {
                case 1: {
                    int n23;
                    double d5;
                    double d6;
                    double d7;
                    double d8 = dArray2[n4 - 2];
                    dArray2[n4 - 2] = 0.0;
                    for (int i = n4 - 2; i >= n2; --i) {
                        d7 = MathUtils.hypot(this.s[i], d8);
                        d6 = this.s[i] / d7;
                        d5 = d8 / d7;
                        this.s[i] = d7;
                        if (i != n2) {
                            d8 = -d5 * dArray2[i - 1];
                            dArray2[i - 1] = d6 * dArray2[i - 1];
                        }
                        if (!bl2) continue;
                        for (n23 = 0; n23 < this.n; ++n23) {
                            d7 = d6 * this.V[n23][i] + d5 * this.V[n23][n4 - 1];
                            this.V[n23][n4 - 1] = -d5 * this.V[n23][i] + d6 * this.V[n23][n4 - 1];
                            this.V[n23][i] = d7;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int n23;
                    double d5;
                    double d6;
                    double d7;
                    double d9 = dArray2[n2 - 1];
                    dArray2[n2 - 1] = 0.0;
                    for (int i = n2; i < n4; ++i) {
                        d7 = MathUtils.hypot(this.s[i], d9);
                        d6 = this.s[i] / d7;
                        d5 = d9 / d7;
                        this.s[i] = d7;
                        d9 = -d5 * dArray2[i];
                        dArray2[i] = d6 * dArray2[i];
                        if (!bl) continue;
                        for (n23 = 0; n23 < this.m; ++n23) {
                            d7 = d6 * this.U[n23][i] + d5 * this.U[n23][n2 - 1];
                            this.U[n23][n2 - 1] = -d5 * this.U[n23][i] + d6 * this.U[n23][n2 - 1];
                            this.U[n23][i] = d7;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double d10 = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[n4 - 1]), Math.abs(this.s[n4 - 2])), Math.abs(dArray2[n4 - 2])), Math.abs(this.s[n2])), Math.abs(dArray2[n2]));
                    double d11 = this.s[n4 - 1] / d10;
                    double d12 = this.s[n4 - 2] / d10;
                    double d13 = dArray2[n4 - 2] / d10;
                    double d14 = this.s[n2] / d10;
                    double d15 = dArray2[n2] / d10;
                    double d16 = ((d12 + d11) * (d12 - d11) + d13 * d13) / 2.0;
                    double d17 = d11 * d13 * (d11 * d13);
                    double d18 = 0.0;
                    if (d16 != 0.0 | d17 != 0.0) {
                        d18 = Math.sqrt(d16 * d16 + d17);
                        if (d16 < 0.0) {
                            d18 = -d18;
                        }
                        d18 = d17 / (d16 + d18);
                    }
                    double d19 = (d14 + d11) * (d14 - d11) + d18;
                    double d20 = d14 * d15;
                    for (int i = n2; i < n4 - 1; ++i) {
                        int n24;
                        double d21 = MathUtils.hypot(d19, d20);
                        double d22 = d19 / d21;
                        double d23 = d20 / d21;
                        if (i != n2) {
                            dArray2[i - 1] = d21;
                        }
                        d19 = d22 * this.s[i] + d23 * dArray2[i];
                        dArray2[i] = d22 * dArray2[i] - d23 * this.s[i];
                        d20 = d23 * this.s[i + 1];
                        this.s[i + 1] = d22 * this.s[i + 1];
                        if (bl2) {
                            for (n24 = 0; n24 < this.n; ++n24) {
                                d21 = d22 * this.V[n24][i] + d23 * this.V[n24][i + 1];
                                this.V[n24][i + 1] = -d23 * this.V[n24][i] + d22 * this.V[n24][i + 1];
                                this.V[n24][i] = d21;
                            }
                        }
                        d21 = MathUtils.hypot(d19, d20);
                        d22 = d19 / d21;
                        d23 = d20 / d21;
                        this.s[i] = d21;
                        d19 = d22 * dArray2[i] + d23 * this.s[i + 1];
                        this.s[i + 1] = -d23 * dArray2[i] + d22 * this.s[i + 1];
                        d20 = d23 * dArray2[i + 1];
                        dArray2[i + 1] = d22 * dArray2[i + 1];
                        if (!bl || i >= this.m - 1) continue;
                        for (n24 = 0; n24 < this.m; ++n24) {
                            d21 = d22 * this.U[n24][i] + d23 * this.U[n24][i + 1];
                            this.U[n24][i + 1] = -d23 * this.U[n24][i] + d22 * this.U[n24][i + 1];
                            this.U[n24][i] = d21;
                        }
                    }
                    dArray2[n4 - 2] = d19;
                    ++n20;
                    break;
                }
                case 4: {
                    if (this.s[n2] <= 0.0) {
                        double d24 = this.s[n2] = this.s[n2] < 0.0 ? -this.s[n2] : 0.0;
                        if (bl2) {
                            for (n21 = 0; n21 <= n3; ++n21) {
                                this.V[n21][n2] = -this.V[n21][n2];
                            }
                        }
                    }
                    while (n2 < n3 && !(this.s[n2] >= this.s[n2 + 1])) {
                        int n25;
                        double d25 = this.s[n2];
                        this.s[n2] = this.s[n2 + 1];
                        this.s[n2 + 1] = d25;
                        if (bl2 && n2 < this.n - 1) {
                            for (n25 = 0; n25 < this.n; ++n25) {
                                d25 = this.V[n25][n2 + 1];
                                this.V[n25][n2 + 1] = this.V[n25][n2];
                                this.V[n25][n2] = d25;
                            }
                        }
                        if (bl && n2 < this.m - 1) {
                            for (n25 = 0; n25 < this.m; ++n25) {
                                d25 = this.U[n25][n2 + 1];
                                this.U[n25][n2 + 1] = this.U[n25][n2];
                                this.U[n25][n2] = d25;
                            }
                        }
                        ++n2;
                    }
                    n20 = 0;
                    --n4;
                }
            }
        }
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public DoubleMatrix2D getS() {
        double[][] dArray = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = 0.0;
            }
            dArray[i][i] = this.s[i];
        }
        return DoubleFactory2D.dense.make(dArray);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DoubleMatrix2D getU() {
        return DoubleFactory2D.dense.make(this.U).viewPart(0, 0, this.m, Math.min(this.m + 1, this.n));
    }

    public DoubleMatrix2D getV() {
        return DoubleFactory2D.dense.make(this.V);
    }

    public double norm2() {
        return this.s[0];
    }

    public int rank() {
        double d = Math.pow(2.0, -52.0);
        double d2 = (double)Math.max(this.m, this.n) * this.s[0] * d;
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > d2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

