/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.scalarfield;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;
import usf.saav.scalarfield.ScalarFieldND;

public interface ScalarField2D
extends ScalarFieldND {
    public int getWidth();

    public int getHeight();

    public float getValue(int var1, int var2);

    public double[] getCoordinate(int var1, int var2);

    public static class RandomField
    extends ArrayField {
        public RandomField(int n, int n2) {
            this(n, n2, 0L);
        }

        public RandomField(int n, int n2, long l) {
            super(n, n2);
            int n3;
            Random random = new Random();
            random.setSeed(l);
            for (n3 = 0; n3 < this.data.length; ++n3) {
                this.data[n3] = random.nextFloat() * 100.0f;
            }
            for (n3 = 2; n3 < Math.min(n, n2); n3 *= 2) {
                for (int i = 0; i < n2; i += n3) {
                    for (int j = 0; j < n; j += n3) {
                        float f = (random.nextFloat() * random.nextFloat() + random.nextFloat()) * 100.0f / (float)n3;
                        for (int k = 0; k < n3 && i + k < n2; ++k) {
                            for (int i2 = 0; i2 < n3 && j + i2 < n; ++i2) {
                                int n4 = (i + k) * n + (j + i2);
                                this.data[n4] = this.data[n4] + f;
                            }
                        }
                    }
                }
            }
        }
    }

    public static class MeanFilterField
    extends ArrayField {
        public MeanFilterField(ScalarField2D scalarField2D, int n) {
            super(scalarField2D.getWidth(), scalarField2D.getHeight());
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    float f = 0.0f;
                    int n2 = 0;
                    for (int k = -n / 2; k < n / 2 && i + k < this.height; ++k) {
                        for (int i2 = -n / 2; i2 < n / 2 && j + i2 < this.width; ++i2) {
                            if (j + i2 < 0 || i + k < 0) continue;
                            f += scalarField2D.getValue(j + i2, i + k);
                            ++n2;
                        }
                    }
                    this.data[i * this.width + j] = f / (float)n2;
                }
            }
        }
    }

    public static class UniqueField
    extends ArrayField {
        public UniqueField(ScalarField2D scalarField2D) {
            super(scalarField2D.getWidth(), scalarField2D.getHeight());
            int n;
            Vector<val_sorter> vector = new Vector<val_sorter>();
            for (n = 0; n < this.data.length; ++n) {
                this.data[n] = scalarField2D.getValue(n);
                vector.add(new val_sorter(this, n));
            }
            Collections.sort(vector, new Comparator<val_sorter>(){

                @Override
                public int compare(val_sorter val_sorter2, val_sorter val_sorter3) {
                    if (data[val_sorter2.idx] < data[val_sorter3.idx]) {
                        return -1;
                    }
                    if (data[val_sorter2.idx] > data[val_sorter3.idx]) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (n = 0; n < vector.size(); ++n) {
                this.data[((val_sorter)vector.get((int)n)).idx] = (float)n / (float)(vector.size() - 1) * 100.0f;
            }
        }

        class val_sorter {
            int idx;

            val_sorter(UniqueField uniqueField, int n) {
                this.idx = n;
            }
        }
    }

    public static class MedianFilterField
    extends ArrayField {
        public MedianFilterField(ScalarField2D scalarField2D, int n) {
            super(scalarField2D.getWidth(), scalarField2D.getHeight());
            float[] fArray = new float[n * n];
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n2;
                    int n3 = 0;
                    for (n2 = -n / 2; n2 < n / 2 && i + n2 < this.height; ++n2) {
                        for (int k = -n / 2; k < n / 2 && j + k < this.width; ++k) {
                            if (j + k < 0 || i + n2 < 0) continue;
                            fArray[n3++] = scalarField2D.getValue(j + k, i + n2);
                        }
                    }
                    for (n2 = n3; n2 < n * n; ++n2) {
                        fArray[n2] = Float.MAX_VALUE;
                    }
                    Arrays.sort(fArray);
                    this.data[i * this.width + j] = fArray[n3 / 2];
                }
            }
        }
    }

    public static class ArrayField
    extends Default {
        float[] data;
        int width;
        int height;

        public ArrayField(int n, int n2) {
            this.data = new float[n * n2];
            this.width = n;
            this.height = n2;
        }

        public ArrayField(String string) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String[] stringArray = bufferedReader.readLine().split("\\s+");
            this.width = Integer.valueOf(stringArray[0]);
            this.height = Integer.valueOf(stringArray[1]);
            this.data = new float[this.width * this.height];
            for (int i = 0; i < this.height; ++i) {
                String[] stringArray2 = bufferedReader.readLine().split("\\s+");
                for (int j = 0; j < stringArray2.length && j < this.width; ++j) {
                    this.data[i * this.width + j] = Float.valueOf(stringArray2[j]).floatValue();
                }
            }
            bufferedReader.close();
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public float getValue(int n, int n2) {
            return this.data[n2 * this.width + n];
        }

        @Override
        public float getValue(int n) {
            return this.data[n];
        }
    }

    public static class Empty
    extends Default {
        int w;
        int h;
        float default_val;

        public Empty(int n, int n2, float f) {
            this.w = n;
            this.h = n2;
            this.default_val = f;
        }

        public Empty(int n, int n2, float f, boolean bl) {
            this.w = n;
            this.h = n2;
            this.default_val = f;
        }

        @Override
        public int getWidth() {
            return this.w;
        }

        @Override
        public int getHeight() {
            return this.h;
        }

        @Override
        public float getValue(int n, int n2) {
            return this.default_val;
        }
    }

    public static abstract class Default
    extends ScalarFieldND.Default
    implements ScalarField2D {
        protected Default() {
        }

        @Override
        public double[] getCoordinate(int n, int n2) {
            return new double[]{n, n2};
        }

        @Override
        public int getSize() {
            return this.getWidth() * this.getHeight();
        }

        @Override
        public float getValue(int n) {
            return this.getValue(n % this.getWidth(), n / this.getWidth());
        }

        public boolean isValid(int n) {
            return !Float.isNaN(this.getValue(n));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getWidth();
            for (int i = 0; i < this.getSize(); ++i) {
                stringBuilder.append(String.format("%1.6f", Float.valueOf(this.getValue(i))));
                stringBuilder.append(" ");
                if (i % n != n - 1) continue;
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }

    public static class Padded
    extends Default {
        int w;
        int h;
        ScalarField2D base;

        public Padded(ScalarField2D scalarField2D, int n, int n2) {
            this.base = scalarField2D;
            this.w = scalarField2D.getWidth() + n - 1;
            this.h = scalarField2D.getHeight() + n2 - 1;
            this.w -= this.w % n;
            this.h -= this.h % n2;
            System.out.println(scalarField2D.getWidth() + " " + scalarField2D.getHeight() + " == " + this.w + " " + this.h);
        }

        @Override
        public int getWidth() {
            return this.w;
        }

        @Override
        public int getHeight() {
            return this.h;
        }

        @Override
        public float getValue(int n, int n2) {
            if (n < this.base.getWidth() && n2 < this.base.getHeight()) {
                return this.base.getValue(n, n2);
            }
            return 0.0f;
        }
    }
}

