/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq.Tree.treePruning.mdlTreePruning;

import dmLab.classifier.sliq.Tree.Node;
import dmLab.classifier.sliq.Tree.Tree;
import dmLab.classifier.sliq.Tree.treePruning.TreePruning;

public final class MdlTreePruning
extends TreePruning {
    private double[][] attrCountMatrix;
    private int attributesNumber;
    private long start = System.currentTimeMillis();
    private long stop = 0L;

    /*
     * WARNING - void declaration
     */
    public MdlTreePruning(Tree tree) {
        super(tree);
        void var1_1;
        this.attributesNumber = tree.getAttributesNumber();
        this.attrCountMatrix = new double[this.attributesNumber][2];
        int attrIndex = 0;
        while (attrIndex < this.attributesNumber) {
            this.attrCountMatrix[attrIndex][0] = 0.0;
            this.attrCountMatrix[attrIndex][1] = 0.0;
            ++attrIndex;
        }
        this.attrCount(var1_1.root);
        attrIndex = 0;
        while (attrIndex < this.attributesNumber) {
            if (this.attrCountMatrix[attrIndex][0] > 0.0) {
                this.attrCountMatrix[attrIndex][1] = Math.log(this.attrCountMatrix[attrIndex][0]) / Math.log(2.0);
            }
            ++attrIndex;
        }
    }

    public final void treePrune() {
        MdlTreePruning mdlTreePruning = this;
        mdlTreePruning.runMdl(mdlTreePruning.tree.root);
        this.stop = System.currentTimeMillis();
        this.tree.setTreePruningTime((float)(this.stop - this.start) / 1000.0f);
    }

    private void runMdl(Node node) {
        while (true) {
            Node node2;
            Node node3 = node;
            Object object = this;
            object = node3;
            if (1.0 + (double)node2.getErrorsNumber() < this.costBoth(node)) {
                MdlTreePruning.pruneChildNodes(node);
            }
            if (node.getLeafIndicator()) break;
            if (node.left != null) {
                this.runMdl(node.left);
            }
            if (node.right == null) break;
            node = node.right;
        }
    }

    private static void pruneChildNodes(Node node) {
        Node node2;
        node.left = null;
        node.right = null;
        node2.setLeafIndicator(true);
    }

    private void attrCount(Node node) {
        while (true) {
            if (!node.getLeafIndicator()) {
                double[] dArray = this.attrCountMatrix[node.getSplittingAttrIndex()];
                dArray[0] = dArray[0] + 1.0;
            }
            if (node.left != null) {
                this.attrCount(node.left);
            }
            if (node.right == null) break;
            node = node.right;
        }
    }

    /*
     * WARNING - void declaration
     */
    private double costLeaf(Node node) {
        void var1_1;
        return 1.0 + (double)var1_1.getErrorsNumber();
    }

    /*
     * WARNING - void declaration
     */
    private double costBoth(Node node) {
        void var1_1;
        if (node.getLeafIndicator()) {
            return this.costLeaf(node);
        }
        return 1.0 + this.lTest(node) + this.costBoth(node.left) + this.costBoth(var1_1.right);
    }

    /*
     * WARNING - void declaration
     */
    private double lTest(Node node) {
        void var1_1;
        if (!node.getSplittingAttrType()) {
            return this.attrCountMatrix[node.getSplittingAttrIndex()][1];
        }
        return Math.log(var1_1.getSplittingValues()[0]) / Math.log(2.0);
    }
}

