/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.integer.IntOffsetView;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class Task {
    private final IntVar start;
    private final IntVar duration;
    private final IntVar end;
    private IVariableMonitor<IntVar> update;

    public Task(Model model, int est, int lst, int d, int ect, int lct) {
        this.start = model.intVar(est, lst);
        this.duration = model.intVar(d);
        if (ect == est + d && lct == lst + d) {
            this.end = this.start.getModel().intOffsetView(this.start, d);
        } else {
            this.end = model.intVar(ect, lct);
            this.declareMonitor();
        }
    }

    public Task(IntVar s, int d) {
        this.start = s;
        this.duration = this.start.getModel().intVar(d);
        this.end = this.start.getModel().intOffsetView(this.start, d);
    }

    public Task(IntVar s, int d, IntVar e) {
        this.start = s;
        this.duration = this.start.getModel().intVar(d);
        this.end = e;
        if (!Task.isOffsetView(s, d, e)) {
            this.declareMonitor();
        }
    }

    public Task(IntVar s, IntVar d, IntVar e) {
        this.start = s;
        this.duration = d;
        this.end = e;
        if (!d.isInstantiated() || !Task.isOffsetView(s, d.getValue(), e)) {
            this.declareMonitor();
        }
    }

    private static boolean isOffsetView(IntVar s, int d, IntVar e) {
        if (e instanceof IntOffsetView) {
            IntOffsetView intOffsetView = (IntOffsetView)e;
            return intOffsetView.cste == d && intOffsetView.getVariable().equals(s);
        }
        return false;
    }

    private void declareMonitor() {
        this.update = this.start.hasEnumeratedDomain() || this.duration.hasEnumeratedDomain() || this.end.hasEnumeratedDomain() ? new TaskMonitor(this.start, this.duration, this.end, true) : new TaskMonitor(this.start, this.duration, this.end, false);
        Model model = this.start.getModel();
        ArrayList<Task> tset = (ArrayList<Task>)model.getHook("H_TASKSET");
        if (tset == null) {
            tset = new ArrayList<Task>();
            model.addHook("H_TASKSET", tset);
        }
        tset.add(this);
    }

    public void ensureBoundConsistency() throws ContradictionException {
        this.update.onUpdate(this.start, IntEventType.REMOVE);
    }

    public IntVar getStart() {
        return this.start;
    }

    public IntVar getDuration() {
        return this.duration;
    }

    public IntVar getEnd() {
        return this.end;
    }

    public IVariableMonitor<IntVar> getMonitor() {
        return this.update;
    }

    private static void doExplain(IntVar S, IntVar D2, IntVar E, int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        IntIterableRangeSet dom = explanation.complement(S);
        if (S == pivot) {
            IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
            S.intersectLit(dom, explanation);
        } else {
            S.unionLit(dom, explanation);
        }
        dom = explanation.complement(D2);
        if (D2 == pivot) {
            IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
            D2.intersectLit(dom, explanation);
        } else {
            D2.unionLit(dom, explanation);
        }
        dom = explanation.complement(E);
        if (E == pivot) {
            IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
            E.intersectLit(dom, explanation);
        } else {
            E.unionLit(dom, explanation);
        }
    }

    public String toString() {
        return "Task[start=" + this.start + ", duration=" + this.duration + ", end=" + this.end + ']';
    }

    private static class TaskMonitor
    implements IVariableMonitor<IntVar> {
        private final IntVar S;
        private final IntVar D;
        private final IntVar E;
        private final boolean isEnum;

        private TaskMonitor(IntVar S, IntVar D2, IntVar E, boolean isEnum) {
            this.S = S;
            this.D = D2;
            this.E = E;
            S.addMonitor(this);
            D2.addMonitor(this);
            E.addMonitor(this);
            this.isEnum = isEnum;
        }

        @Override
        public void onUpdate(IntVar var, IEventType evt) throws ContradictionException {
            do {
                boolean fixpoint = this.S.updateBounds(this.E.getLB() - this.D.getUB(), this.E.getUB() - this.D.getLB(), this);
                fixpoint |= this.E.updateBounds(this.S.getLB() + this.D.getLB(), this.S.getUB() + this.D.getUB(), this);
            } while ((fixpoint |= this.D.updateBounds(this.E.getLB() - this.S.getUB(), this.E.getUB() - this.S.getLB(), this)) && this.isEnum);
        }

        @Override
        public void explain(int p, ExplanationForSignedClause explanation) {
            Task.doExplain(this.S, this.D, this.E, p, explanation);
        }

        @Override
        public void forEachIntVar(Consumer<IntVar> action) {
            action.accept(this.S);
            action.accept(this.D);
            action.accept(this.E);
        }

        public String toString() {
            return "Task[" + this.S.getName() + "+" + this.D.getName() + "=" + this.E.getName() + "]";
        }
    }
}

