/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.table;

import com.qarks.util.ui.swing.table.RenderInfo;
import com.qarks.util.ui.swing.table.RenderInfoProvider;
import com.qarks.util.ui.swing.table.SingleObjectTableColumn;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SimpleTableColumn
extends SingleObjectTableColumn {
    private CellRenderer cellRenderer = new CellRenderer();
    private RenderInfoProvider renderInfoProvider;

    public SimpleTableColumn(RenderInfoProvider renderInfoProvider) {
        this.renderInfoProvider = renderInfoProvider;
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    @Override
    public Class getColumnClass() {
        return RenderInfo.class;
    }

    @Override
    public Object getAttribute(Object object) {
        return this.renderInfoProvider.getRenderInfo(object);
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof RenderInfo) {
                RenderInfo renderInfo = (RenderInfo)object;
                if (renderInfo.getText() != null) {
                    this.setText(renderInfo.getText());
                } else {
                    this.setText("");
                }
                this.setIcon(renderInfo.getIcon());
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }
    }
}

