/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.PreferenceManagerImpl;
import com.qarks.util.files.diff.ui.MergeContentResult;
import com.qarks.util.files.diff.ui.MergePanel;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FileMergeDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private MergePanel editor;
    private boolean cancelled = false;
    private static boolean exitOnClose = false;

    public FileMergeDialog(Window window, String string, String string2, String string3) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        super.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (FileMergeDialog.this.ok.isEnabled()) {
                    FileMergeDialog.this.actionPerformed(new ActionEvent(FileMergeDialog.this.ok, 0, "close"));
                }
            }
        });
        this.editor = new MergePanel(string2, string3, PreferenceManagerImpl.getInstance().getProperty("charset.default", ""));
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.editor, "Center");
        container.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.setSize(800, 600);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            if (!exitOnClose) {
                boolean bl = true;
                String string = this.editor.getMergedFileContent();
                if (string.length() == 0) {
                    Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.YES), ResourceManager.getString((Object)ResourceKey.NO)};
                    int n = JOptionPane.showOptionDialog(this, ResourceManager.getString((Object)ResourceKeyDiff.MERGE_EMPTY_CONFIRM), ResourceManager.getString((Object)ResourceKey.MERGE), -1, 3, null, objectArray, objectArray[1]);
                    boolean bl2 = bl = n == 0;
                }
                if (bl) {
                    this.dispose();
                }
            } else {
                System.exit(0);
            }
        } else if (object == this.cancel) {
            if (exitOnClose) {
                System.exit(0);
            } else {
                this.cancelled = true;
                this.dispose();
            }
        }
    }

    private MergeContentResult showAndCompute(Window window, File file, File file2, File file3) {
        this.editor.launchMerge(file, file2, file3);
        if (window != null && window.isShowing()) {
            DialogUtilities.centerWindow(this, window);
        } else {
            DialogUtilities.centerOnScreen(this);
        }
        String string = null;
        if (!this.cancelled) {
            string = this.editor.getMergedFileContent();
        }
        MergeContentResult mergeContentResult = new MergeContentResult();
        mergeContentResult.content = string;
        mergeContentResult.charset = this.editor.getSelectedCharset();
        return mergeContentResult;
    }

    public static MergeContentResult showMergeDialog(Window window, String string, File file, String string2, File file2, String string3, File file3) {
        FileMergeDialog fileMergeDialog = new FileMergeDialog(window, string, string2, string3);
        return fileMergeDialog.showAndCompute(window, file, file2, file3);
    }

    static {
        ResourceManager.getInstance().addBundleName("resources/jdiff/properties/TextResources");
    }
}

